/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.EffectPlayer;
import com.elmakers.mine.bukkit.utilities.EffectRing;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PushSpell
extends Spell {
    private int DEFAULT_ITEM_MAGNITUDE = 1;
    private int DEFAULT_ENTITY_MAGNITUDE = 3;
    private int DEFAULT_MAX_ALL_DISTANCE = 20;
    private static final int effectSpeed = 2;
    private static final int effectPeriod = 2;
    private static final int ringEffectAmount = 8;
    private static final int maxEffectRange = 16;
    private static final int maxRingEffectRange = 6;

    public void forceAll(double mutliplier, boolean pull, int entityMagnitude, int itemMagnitude, int maxAllDistance) {
        float maxDistance = (float)maxAllDistance * this.playerSpells.getRangeMultiplier();
        float maxDistanceSquared = maxDistance * maxDistance;
        int effectRange = Math.min(6, 8);
        Location effectLocation = this.player.getLocation();
        EffectRing effectRing = new EffectRing((Plugin)this.spells.getPlugin(), effectLocation, effectRange, 8);
        if (pull) {
            effectRing.setInvert(true);
        }
        this.startEffect(effectRing, effectRange);
        List entities = this.player.getWorld().getEntities();
        for (Entity target : entities) {
            Location targetLocation;
            Location playerLocation;
            if (target == this.player || (playerLocation = this.player.getLocation()).distanceSquared(targetLocation = target.getLocation()) > (double)maxDistanceSquared) continue;
            Location to = pull ? targetLocation : playerLocation;
            Location from = pull ? playerLocation : targetLocation;
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.forceEntity(target, mutliplier, from, to, magnitude);
        }
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean push = false;
        boolean pull = false;
        String typeString = parameters.getString("type", "");
        push = typeString.equals("push");
        pull = typeString.equals("pull");
        double multiplier = parameters.getDouble("size", 1.0);
        if (push) {
            multiplier *= (double)this.playerSpells.getDamageMultiplier();
        }
        int count = parameters.getInt("count", 0);
        boolean allowAll = parameters.getBoolean("allow_area", true);
        int itemMagnitude = parameters.getInt("item_force", this.DEFAULT_ITEM_MAGNITUDE);
        int entityMagnitude = parameters.getInt("entity_force", this.DEFAULT_ENTITY_MAGNITUDE);
        int maxAllDistance = parameters.getInt("area_range", this.DEFAULT_MAX_ALL_DISTANCE);
        this.targetEntity(Entity.class);
        List<Target> targets = this.getAllTargetEntities();
        if (allowAll && (this.getYRotation() < -80.0 || this.getYRotation() > 80.0)) {
            if (push) {
                this.castMessage("Get away!");
            } else {
                this.castMessage("Gimme!");
            }
            this.forceAll(multiplier, pull, entityMagnitude, itemMagnitude, maxAllDistance);
            return SpellResult.SUCCESS;
        }
        int effectRange = Math.min(this.getMaxRange(), 8);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        if (pull) {
            effectDirection.normalize();
            effectDirection.multiply(2 * effectRange);
            effectLocation.add(effectDirection);
            effectDirection.multiply(-1);
        }
        EffectTrail effectTrail = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        this.startEffect(effectTrail, effectRange);
        if (targets.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        int pushed = 0;
        for (Target target : targets) {
            Entity targetEntity = target.getEntity();
            Location to = pull ? target.getLocation() : this.player.getLocation();
            Location from = pull ? this.player.getLocation() : target.getLocation();
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.forceEntity(targetEntity, multiplier, from, to, magnitude);
            if (count > 0 && ++pushed >= count) break;
        }
        if (pull) {
            this.castMessage("Yoink!");
        } else {
            this.castMessage("Shove!");
        }
        return SpellResult.SUCCESS;
    }

    protected void forceEntity(Entity target, double multiplier, Location from, Location to, int magnitude) {
        Vector fromVector;
        magnitude = (int)((double)magnitude * multiplier);
        Vector toVector = new Vector(to.getBlockX(), to.getBlockY(), to.getBlockZ());
        Vector forceVector = fromVector = new Vector(from.getBlockX(), from.getBlockY(), from.getBlockZ());
        forceVector.subtract(toVector);
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }

    protected void startEffect(EffectPlayer effect, int effectRange) {
        effect.setParticleType(ParticleType.SPELL);
        effect.setParticleCount(3);
        Color effectColor = this.playerSpells.getEffectColor();
        effect.setEffectData(effectColor != null ? effectColor.asRGB() : 2);
        effect.setParticleOffset(0.2f, 0.2f, 0.2f);
        effect.setSpeed(2.0f);
        effect.setPeriod(2);
        effect.start();
    }
}

