/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.WitherSkull;

public class ProjectileSpell
extends Spell {
    int defaultSize = 1;

    public SpellResult onCast(ConfigurationNode parameters) {
        if (!this.playerSpells.hasBuildPermission(this.player.getLocation())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int size = parameters.getInt("size", this.defaultSize);
        size = (int)(this.playerSpells.getRadiusMultiplier() * (float)size);
        boolean useFire = parameters.getBoolean("fire", true);
        String projectileClass = parameters.getString("projectile", "Fireball");
        try {
            Location playerLocation = this.player.getLocation();
            Class<?> projectileType = Class.forName("org.bukkit.entity." + projectileClass);
            Projectile projectile = this.player.launchProjectile(projectileType);
            projectile.setShooter((LivingEntity)this.player);
            if (projectile instanceof WitherSkull) {
                playerLocation.getWorld().playSound(playerLocation, Sound.WITHER_SHOOT, 1.0f, 1.5f);
            }
            if (projectile instanceof Fireball) {
                Fireball fireball = (Fireball)projectile;
                fireball.setIsIncendiary(useFire);
                fireball.setYield((float)size);
                if (!(projectile instanceof WitherSkull)) {
                    playerLocation.getWorld().playSound(playerLocation, Sound.GHAST_FIREBALL, 1.0f, 1.5f);
                }
            }
        }
        catch (Exception ex) {
            this.sendMessage("Unknown projectile class " + projectileClass);
            return SpellResult.FAILURE;
        }
        return SpellResult.SUCCESS;
    }
}

