/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class ForceSpell
extends Spell {
    LivingEntity targetEntity = null;
    private Color effectColor = null;
    private static final int DEFAULT_MAGNITUDE = 3;

    public SpellResult onCast(ConfigurationNode parameters) {
        if (this.targetEntity != null && this.targetEntity instanceof LivingEntity) {
            if (!this.targetEntity.isValid() || this.targetEntity.isDead()) {
                this.releaseTarget();
            }
            if (this.targetEntity != null && this.player.getLocation().distanceSquared(this.targetEntity.getLocation()) > (double)this.getMaxRangeSquared()) {
                this.releaseTarget();
            }
        }
        if (this.targetEntity == null) {
            this.targetEntity(LivingEntity.class);
            Target target = this.getTarget();
            if (!(target != null && target.hasTarget() && target.isEntity() && target.getEntity() instanceof LivingEntity)) {
                this.targetEntity = null;
                return SpellResult.NO_TARGET;
            }
            this.effectColor = this.playerSpells.getEffectColor();
            if (this.effectColor == null) {
                this.effectColor = Color.fromRGB((int)Integer.parseInt(parameters.getString("effect_color", "FF0000"), 16));
            }
            this.targetEntity = (LivingEntity)target.getEntity();
            if (this.effectColor != null) {
                InventoryUtils.addPotionEffect(this.targetEntity, this.effectColor);
            }
            return SpellResult.COST_FREE;
        }
        double multiplier = parameters.getDouble("size", 1.0);
        int magnitude = parameters.getInt("entity_force", 3);
        this.forceEntity((Entity)this.targetEntity, multiplier, magnitude);
        return SpellResult.SUCCESS;
    }

    protected void forceEntity(Entity target, double multiplier, int magnitude) {
        magnitude = (int)((double)magnitude * multiplier);
        Vector forceVector = this.getAimVector();
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }

    protected void releaseTarget() {
        if (this.targetEntity != null && this.effectColor != null) {
            InventoryUtils.clearPotionEffect(this.targetEntity);
        }
        this.targetEntity = null;
    }

    public boolean onCancel() {
        if (this.targetEntity != null) {
            if (this.targetEntity instanceof LivingEntity && !this.targetEntity.isDead() && this.player.getLocation().distanceSquared(this.targetEntity.getLocation()) > (double)this.getMaxRangeSquared()) {
                this.castMessage("Released target");
            }
            this.releaseTarget();
            return true;
        }
        return false;
    }
}

