/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.blocks.FillBatch;
import com.elmakers.mine.bukkit.utilities.BlockRecurse;
import com.elmakers.mine.bukkit.utilities.EffectUtils;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.ReplaceMaterialAction;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class FillSpell
extends Spell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private static final int DEFAULT_MAX_VOLUME = 512;
    private Block targetBlock = null;
    private final BlockRecurse blockRecurse = new BlockRecurse();

    public SpellResult onCast(ConfigurationNode parameters) {
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.noTargetThrough(Material.WATER);
        Block targetBlock = this.getTargetBlock();
        Material material = Material.AIR;
        byte data = 0;
        boolean singleBlock = false;
        boolean recurse = false;
        boolean overrideMaterial = false;
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = FillSpell.getItemData(buildWith);
            overrideMaterial = true;
        }
        String typeString = parameters.getString("type", "");
        singleBlock = typeString.equals("single");
        recurse = typeString.equals("recurse");
        Material materialOverride = parameters.getMaterial("material");
        if (materialOverride != null) {
            material = materialOverride;
            data = 0;
            overrideMaterial = true;
        }
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (recurse) {
            this.deactivate();
            int size = parameters.getInt("size", 8);
            size = (int)(this.playerSpells.getRadiusMultiplier() * (float)size);
            this.blockRecurse.setMaxRecursion(size);
            PlayerSpells playerSpells = this.spells.getPlayerSpells(this.player);
            Material targetMaterial = targetBlock.getType();
            ReplaceMaterialAction action = new ReplaceMaterialAction(playerSpells, targetBlock, material, data);
            if (targetMaterial == Material.STATIONARY_WATER) {
                action.addReplaceable(Material.WATER);
            } else if (targetMaterial == Material.WATER) {
                action.addReplaceable(Material.STATIONARY_WATER);
            } else if (targetMaterial == Material.STATIONARY_LAVA) {
                action.addReplaceable(Material.LAVA);
            } else if (targetMaterial == Material.LAVA) {
                action.addReplaceable(Material.STATIONARY_LAVA);
            }
            this.blockRecurse.recurse(targetBlock, action);
            this.spells.addToUndoQueue(this.player, action.getBlocks());
            this.spells.updateBlock(targetBlock);
            this.castMessage("Filled " + action.getBlocks().size() + " blocks with " + material.name().toLowerCase());
            return SpellResult.SUCCESS;
        }
        if (singleBlock) {
            this.deactivate();
            BlockList filledBlocks = new BlockList();
            filledBlocks.add(targetBlock);
            targetBlock.setType(material);
            targetBlock.setData(data);
            this.spells.updateBlock(targetBlock);
            this.castMessage("Painting with " + material.name().toLowerCase());
            this.spells.addToUndoQueue(this.player, filledBlocks);
            return SpellResult.SUCCESS;
        }
        if (this.targetBlock != null) {
            if (!overrideMaterial) {
                material = this.targetBlock.getType();
                data = this.targetBlock.getData();
            }
            FillBatch batch = new FillBatch(this, targetBlock.getLocation(), this.targetBlock.getLocation(), material, data);
            int maxDimension = parameters.getInteger("max_dimension", 128);
            int maxVolume = parameters.getInteger("max_volume", 512);
            maxDimension = (int)(this.playerSpells.getConstructionMultiplier() * (float)maxDimension);
            maxVolume = (int)(this.playerSpells.getConstructionMultiplier() * (float)maxVolume);
            if (!batch.checkDimension(maxDimension)) {
                this.sendMessage("Dimension is too big!");
                return SpellResult.FAILURE;
            }
            if (!batch.checkVolume(maxVolume)) {
                this.sendMessage("Volume is too big!");
                return SpellResult.FAILURE;
            }
            this.spells.addPendingBlockBatch(batch);
            this.deactivate();
            return SpellResult.SUCCESS;
        }
        Location effectLocation = targetBlock.getLocation();
        effectLocation.add(0.5, 0.5, 0.5);
        EffectUtils.playEffect(effectLocation, ParticleType.HAPPY_VILLAGER, 0.3f, 0.3f, 0.3f, 1.0f, 16);
        this.targetBlock = targetBlock;
        if (!overrideMaterial) {
            material = targetBlock.getType();
        }
        this.activate();
        this.castMessage("Cast again to fill with " + material.name().toLowerCase());
        return SpellResult.SUCCESS;
    }

    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.sendMessage("Cancelled fill");
            this.targetBlock = null;
            return true;
        }
        return false;
    }

    public boolean usesMaterial() {
        return true;
    }

    public void onDeactivate() {
        this.targetBlock = null;
    }
}

