/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.WandChestPopulator;
import com.elmakers.mine.bukkit.utilities.NMSUtils;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class WandChestRunnable
extends BukkitRunnable {
    private World world;
    private int dx = 1;
    private int dz = 0;
    private int segmentLength = 1;
    private int x;
    private int z;
    private int segmentPassed = 0;
    private int chunksProcessed = 0;
    static final int messageInterval = 100;
    WandChestPopulator populator;
    Random random;
    Logger logger;
    boolean finished = false;

    public WandChestRunnable(Spells spells, World world, int maxy) {
        this.world = world;
        this.random = new Random();
        this.logger = spells.getPlugin().getLogger();
        if (maxy > 0) {
            this.populator = spells.getWandChestPopulator();
            this.populator.setMaxY(maxy);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void run() {
        Chunk chunk = this.world.getChunkAt(this.x, this.z);
        if (!NMSUtils.isDone(chunk) || !chunk.isLoaded()) {
            if (!NMSUtils.isDone(chunk) || !chunk.load(false)) {
                this.logger.info("Done populating chests, found ungenerated chunk");
                this.finished = true;
                this.cancel();
            }
        } else {
            if (this.chunksProcessed % 100 == 0) {
                if (this.populator != null) {
                    this.logger.info("Looking for chests, processed " + this.chunksProcessed + " chunks");
                } else {
                    this.logger.info("Looking for wands, searched " + this.chunksProcessed + " chunks");
                }
            }
            ++this.chunksProcessed;
            if (this.populator != null) {
                this.populator.populate(this.world, this.random, chunk);
            }
            this.x += this.dx;
            this.z += this.dz;
            ++this.segmentPassed;
            if (this.segmentPassed == this.segmentLength) {
                this.segmentPassed = 0;
                int odx = this.dx;
                this.dx = -this.dz;
                this.dz = odx;
                if (this.dz == 0) {
                    ++this.segmentLength;
                }
            }
        }
    }
}

