/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.SimpleBlockAction;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FireSpell
extends Spell {
    private static final int DEFAULT_RADIUS = 4;
    private static final int maxEffectRange = 16;
    private static final int effectSpeed = 1;
    private static final float particleData = 0.2f;
    private static final int effectPeriod = 2;
    private static final int particleCount = 1;

    public SpellResult onCast(ConfigurationNode parameters) {
        int effectRange = Math.min(this.getMaxRange(), 16);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effectTrail = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        effectTrail.setParticleType(ParticleType.FLAME);
        effectTrail.setParticleCount(1);
        effectTrail.setEffectData(0.2f);
        effectTrail.setParticleOffset(0.2f, 0.2f, 0.2f);
        effectTrail.setSpeed(1.0f);
        effectTrail.setPeriod(2);
        effectTrail.start();
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int radius = parameters.getInt("radius", 4);
        radius = (int)(this.playerSpells.getPowerMultiplier() * (float)radius);
        FireAction action = new FireAction();
        if (radius <= 1) {
            action.perform(target);
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.spells.addToUndoQueue(this.player, action.getBlocks());
        this.castMessage("Burned " + action.getBlocks().size() + " blocks");
        this.spells.updateBlock(target);
        return SpellResult.SUCCESS;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FireAction
    extends SimpleBlockAction {
        public SpellResult perform(Block block) {
            if (block.getType() == Material.AIR || block.getType() == Material.FIRE) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.FIRE;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER || block.getType() == Material.ICE || block.getType() == Material.SNOW) {
                material = Material.AIR;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            block.setType(material);
            return SpellResult.SUCCESS;
        }
    }
}

