/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DisarmSpell
extends Spell {
    private static final int maxEffectRange = 16;
    private static final int effectSpeed = 1;
    private static final float particleData = 2.0f;
    private static final int effectPeriod = 2;
    private static final int particleCount = 6;

    public SpellResult onCast(ConfigurationNode parameters) {
        Player targetPlayer;
        PlayerSpells playerSpells;
        int effectRange = Math.min(this.getMaxRange(), 16);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effectTrail = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        effectTrail.setParticleType(ParticleType.MOB_SPELL);
        effectTrail.setParticleCount(6);
        effectTrail.setEffectData(2.0f);
        effectTrail.setParticleOffset(0.2f, 0.2f, 0.2f);
        effectTrail.setSpeed(1.0f);
        effectTrail.setPeriod(2);
        effectTrail.start();
        Target target = this.getTarget();
        Entity targetEntity = target.getEntity();
        if (targetEntity == null || !(targetEntity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity entity = (LivingEntity)targetEntity;
        EntityEquipment equipment = entity.getEquipment();
        ItemStack stack = equipment.getItemInHand();
        if (stack == null || stack.getType() == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        if (Wand.isWand(stack) && entity instanceof Player && (playerSpells = this.spells.getPlayerSpells(targetPlayer = (Player)entity)) != null && playerSpells.getActiveWand() != null) {
            playerSpells.getActiveWand().deactivate();
        }
        equipment.setItemInHand(null);
        Location location = entity.getLocation();
        location.setY(location.getY() + 1.0);
        Item item = entity.getWorld().dropItemNaturally(location, stack);
        Vector velocity = item.getVelocity();
        velocity.setY(velocity.getY() * 5.0);
        item.setVelocity(velocity);
        return SpellResult.SUCCESS;
    }
}

