/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Set;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class AbsorbSpell
extends Spell {
    private static final int effectSpeed = 1;
    private static final int effectPeriod = 1;
    private static final int maxEffectRange = 4;

    public SpellResult onCast(ConfigurationNode parameters) {
        Block target;
        PlayerSpells playerSpells = this.spells.getPlayerSpells(this.player);
        Wand wand = playerSpells.getActiveWand();
        if (wand == null) {
            this.castMessage("This spell requires a wand");
            return SpellResult.NO_TARGET;
        }
        Material material = Material.AIR;
        Set<Material> buildingMaterials = this.spells.getBuildingMaterials();
        byte data = 0;
        if (!this.isUnderwater()) {
            this.noTargetThrough(Material.STATIONARY_WATER);
            this.noTargetThrough(Material.WATER);
        }
        if ((target = this.getTargetBlock()) == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        material = target.getType();
        data = target.getData();
        int effectRange = Math.min(this.getMaxRange(), 4);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        effectDirection.normalize();
        effectDirection.multiply(1 * effectRange);
        effectLocation.add(effectDirection);
        effectDirection.multiply(-1);
        EffectTrail effect = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        effect.setEffect(Effect.STEP_SOUND);
        effect.setData(material.getId());
        effect.setSpeed(1.0f);
        effect.setPeriod(1);
        effect.start();
        if (material == null || material == Material.AIR || !buildingMaterials.contains(material)) {
            return SpellResult.NO_TARGET;
        }
        wand.addMaterial(material, data, true, true);
        this.castMessage("Absorbing some " + material.name().toLowerCase());
        return SpellResult.SUCCESS;
    }

    public boolean usesMaterial() {
        return true;
    }
}

