/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.UndoQueue;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerSpells
implements CostReducer {
    protected Player player;
    protected String playerName;
    protected Spells master;
    protected HashMap<String, Spell> spells = new HashMap();
    private Inventory storedInventory = null;
    private Wand activeWand = null;
    private final List<Spell> movementListeners = new ArrayList<Spell>();
    private final List<Spell> quitListeners = new ArrayList<Spell>();
    private final List<Spell> deathListeners = new ArrayList<Spell>();
    private final List<Spell> damageListeners = new ArrayList<Spell>();
    private final Set<Spell> activeSpells = new TreeSet<Spell>();
    private UndoQueue undoQueue = null;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private ItemStack buildingMaterial = null;
    private long lastClick = 0L;
    private long blockPlaceTimeout = 0L;

    public void removeExperience(int xp) {
        if (this.activeWand != null && this.activeWand.hasExperience()) {
            this.activeWand.removeExperience(xp);
            return;
        }
        float expProgress = this.player.getExp();
        int expLevel = this.player.getLevel();
        while ((expProgress > 0.0f || expLevel > 0) && xp > 0) {
            if (expProgress > 0.0f) {
                int expAtLevel = (int)(expProgress * (float)this.player.getExpToLevel());
                if (expAtLevel > xp) {
                    xp = 0;
                    expProgress = (float)(expAtLevel -= xp) / (float)PlayerSpells.getExpToLevel(expLevel);
                    continue;
                }
                expProgress = 0.0f;
                xp -= expAtLevel;
                continue;
            }
            --expLevel;
            if ((xp -= this.player.getExpToLevel()) >= 0) continue;
            expProgress = (float)(-xp) / (float)PlayerSpells.getExpToLevel(expLevel);
            xp = 0;
        }
        this.player.setExp(expProgress);
        this.player.setLevel(expLevel);
    }

    public static int getExpToLevel(int expLevel) {
        return expLevel >= 30 ? 62 + (expLevel - 30) * 7 : (expLevel >= 15 ? 17 + (expLevel - 15) * 3 : 17);
    }

    public int getExperience() {
        if (this.activeWand != null && this.activeWand.hasExperience()) {
            return this.activeWand.getExperience();
        }
        int xp = 0;
        float expProgress = this.player.getExp();
        int expLevel = this.player.getLevel();
        int level = 0;
        while (level < expLevel) {
            xp += PlayerSpells.getExpToLevel(level);
            ++level;
        }
        return xp + (int)(expProgress * (float)PlayerSpells.getExpToLevel(expLevel));
    }

    public void setCostReduction(float reduction) {
        this.costReduction = reduction;
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public float getCostReduction() {
        return this.activeWand == null ? this.costReduction : this.activeWand.getCostReduction() + this.costReduction;
    }

    public boolean usesMana() {
        return this.activeWand == null ? false : this.activeWand.usesMana();
    }

    public float getPowerMultiplier() {
        float maxPowerMultiplier = this.master.getMaxPowerMultiplier() - 1.0f;
        return this.activeWand == null ? 1.0f : 1.0f + maxPowerMultiplier * this.activeWand.getPower();
    }

    public float getCooldownReduction() {
        return this.activeWand == null ? this.cooldownReduction : this.activeWand.getCooldownReduction() + this.cooldownReduction;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        for (ItemStack remains : remainder.values()) {
            this.player.getWorld().dropItemNaturally(this.player.getLocation(), remains);
        }
        return true;
    }

    public boolean storeInventory() {
        PlayerInventory inventory = this.player.getInventory();
        if (this.storedInventory != null) {
            return false;
        }
        this.storedInventory = InventoryUtils.createInventory(null, inventory.getSize(), "Stored Inventory");
        ItemStack[] contents = inventory.getContents();
        int i = 0;
        while (i < contents.length) {
            if (Wand.isSpell(contents[i])) {
                contents[i] = null;
            }
            ++i;
        }
        this.storedInventory.setContents(contents);
        inventory.clear();
        return true;
    }

    public boolean restoreInventory() {
        if (this.storedInventory == null || this.player == null) {
            return false;
        }
        PlayerInventory inventory = this.player.getInventory();
        inventory.setContents(this.storedInventory.getContents());
        this.storedInventory = null;
        return true;
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                if (this.movementListeners.contains(spell)) break;
                this.movementListeners.add(spell);
                break;
            }
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    public void setPlayer(Player player) {
        if (player != this.player) {
            this.player = player;
            for (Spell spell : this.spells.values()) {
                spell.setPlayer(player);
            }
        }
        if (player != null) {
            this.playerName = player.getName();
        }
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                this.movementListeners.remove(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    public PlayerSpells(Spells master, Player player) {
        this.master = master;
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean cancel() {
        boolean result = false;
        for (Spell spell : this.spells.values()) {
            boolean bl = result = result || spell.cancel();
        }
        return result;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.quitListeners);
        for (Spell listener : active) {
            listener.onPlayerQuit(event);
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.movementListeners);
        for (Spell listener : active) {
            listener.onPlayerMove(event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.deathListeners);
        for (Spell listener : active) {
            if (this.player != listener.getPlayer()) continue;
            listener.onPlayerDeath(event);
        }
    }

    public void onPlayerCombust(EntityCombustEvent event) {
        if (this.activeWand != null && this.activeWand.getDamageReductionFire() > 0.0f) {
            event.setCancelled(true);
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.damageListeners);
        for (Spell listener : active) {
            listener.onPlayerDamage(event);
        }
        if (event.isCancelled()) {
            return;
        }
        float reduction = 0.0f;
        if (this.activeWand != null) {
            reduction = this.activeWand.getDamageReduction();
            float damageReductionFire = this.activeWand.getDamageReductionFire();
            switch (event.getCause()) {
                case CONTACT: 
                case ENTITY_ATTACK: {
                    reduction += this.activeWand.getDamageReductionPhysical();
                    break;
                }
                case PROJECTILE: {
                    reduction += this.activeWand.getDamageReductionProjectiles();
                    break;
                }
                case FALL: {
                    reduction += this.activeWand.getDamageReductionFalling();
                    break;
                }
                case FIRE: 
                case FIRE_TICK: 
                case LAVA: {
                    if (damageReductionFire > 0.0f && this.player.getFireTicks() > 0) {
                        this.player.setFireTicks(0);
                    }
                    reduction += damageReductionFire;
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    reduction += this.activeWand.getDamageReductionExplosions();
                }
            }
        }
        if (reduction >= 1.0f) {
            event.setCancelled(true);
            return;
        }
        if (reduction > 0.0f) {
            int newDamage = (int)Math.floor((double)(1.0f - reduction) * event.getDamage());
            if (newDamage == 0) {
                newDamage = 1;
            }
            event.setDamage((double)newDamage);
        }
    }

    public Spell getSpell(String name) {
        return this.getSpell(name, this.player);
    }

    public Spell getSpell(String name, Player usePermissions) {
        Spell spell = this.master.getSpell(name);
        if (spell == null || !spell.hasSpellPermission(usePermissions)) {
            return null;
        }
        Spell playerSpell = this.spells.get(spell.getKey());
        if (playerSpell == null) {
            playerSpell = (Spell)spell.clone();
            this.spells.put(spell.getKey(), playerSpell);
        }
        if (this.player != null) {
            playerSpell.setPlayer(this.player);
        }
        return playerSpell;
    }

    public Spells getMaster() {
        return this.master;
    }

    public Inventory getInventory() {
        return this.hasStoredInventory() ? this.getStoredInventory() : this.player.getInventory();
    }

    public Wand getActiveWand() {
        ItemStack currentItem;
        if (this.activeWand != null && this.player != null && Wand.isWand(currentItem = this.player.getItemInHand())) {
            this.activeWand.setItem(currentItem);
        }
        return this.activeWand;
    }

    public void setActiveWand(Wand activeWand) {
        this.activeWand = activeWand;
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
    }

    public long getBlockPlaceTimeout() {
        return this.blockPlaceTimeout;
    }

    public void setBuildingMaterial(Material material, byte data) {
        if (material == Wand.CopyMaterial) {
            this.buildingMaterial = null;
            return;
        }
        if (material == Wand.EraseMaterial) {
            material = Material.AIR;
        }
        this.buildingMaterial = new ItemStack(material, 1, 0, Byte.valueOf(data));
    }

    public void clearBuildingMaterial() {
        this.buildingMaterial = null;
    }

    public ItemStack getBuildingMaterial() {
        return this.buildingMaterial;
    }

    public boolean hasBuildPermission(Location location) {
        return this.master.hasBuildPermission(this.player, location);
    }

    public boolean hasBuildPermission(Block block) {
        return this.master.hasBuildPermission(this.player, block);
    }

    public void onCast(SpellResult result) {
        switch (result) {
            case SUCCESS: {
                break;
            }
            case INSUFFICIENT_RESOURCES: {
                this.playSound(Sound.NOTE_BASS, 1.0f, 1.0f);
                break;
            }
            case INSUFFICIENT_PERMISSION: {
                this.playSound(Sound.NOTE_BASS, 1.0f, 1.5f);
                break;
            }
            case COOLDOWN: {
                this.playSound(Sound.NOTE_SNARE_DRUM, 1.0f, 1.0f);
                break;
            }
            case NO_TARGET: {
                this.playSound(Sound.NOTE_STICKS, 1.0f, 1.0f);
                break;
            }
            case COST_FREE: {
                break;
            }
            default: {
                this.playSound(Sound.NOTE_BASS_DRUM, 1.0f, 1.0f);
            }
        }
    }

    public void playSound(Sound sound, float volume, float pitch) {
        if (this.master.soundsEnabled()) {
            this.player.playSound(this.player.getLocation(), sound, volume, pitch);
        }
    }

    public void activateSpell(Spell spell) {
        this.activeSpells.add(spell);
    }

    public void deactivateSpell(Spell spell) {
        this.activeSpells.remove(spell);
    }

    public void deactivateAllSpells() {
        ArrayList<Spell> active = new ArrayList<Spell>(this.activeSpells);
        for (Spell spell : active) {
            spell.deactivate();
        }
    }

    public void tick() {
        if (this.activeWand != null && this.player.isOnline()) {
            this.activeWand.processRegeneration();
        }
        ArrayList<Spell> active = new ArrayList<Spell>(this.activeSpells);
        for (Spell spell : active) {
            spell.checkActiveDuration();
            spell.checkActiveCosts();
        }
    }

    public UndoQueue getUndoQueue() {
        if (this.undoQueue == null) {
            this.undoQueue = new UndoQueue();
            this.undoQueue.setMaxSize(this.master.getUndoQueueDepth());
        }
        return this.undoQueue;
    }

    protected void load(ConfigurationNode configNode) {
        try {
            if (configNode == null) {
                return;
            }
            this.getUndoQueue().load(this.master, configNode);
            ConfigurationNode spellNode = configNode.getNode("spells");
            if (spellNode != null) {
                List<String> keys = spellNode.getKeys();
                for (String key : keys) {
                    Spell spell = this.getSpell(key);
                    if (spell == null) continue;
                    spell.load(spellNode.getNode(key));
                }
            }
        }
        catch (Exception ex) {
            this.master.getPlugin().getLogger().warning("Failed to save player data for " + this.playerName + ": " + ex.getMessage());
        }
    }

    protected void save(ConfigurationNode configNode) {
        try {
            this.getUndoQueue().save(this.master, configNode);
            ConfigurationNode spellNode = configNode.createChild("spells");
            for (Spell spell : this.spells.values()) {
                spell.save(spellNode.createChild(spell.getKey()));
            }
        }
        catch (Exception ex) {
            this.master.getPlugin().getLogger().warning("Failed to save player data for " + this.playerName + ": " + ex.getMessage());
        }
    }

    public boolean checkLastClick(long maxInterval) {
        long now = System.currentTimeMillis();
        long previous = this.lastClick;
        this.lastClick = now;
        return previous <= 0L || previous + maxInterval < now;
    }

    public Color getEffectColor() {
        int colorValue;
        int n = colorValue = this.activeWand == null ? 0 : this.activeWand.getEffectColor();
        if (colorValue == 0) {
            return null;
        }
        return Color.fromRGB((int)colorValue);
    }

    public FireworkEffect getFireworkEffect() {
        return this.getFireworkEffect(null, null, null, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Color wandColor = this.getEffectColor();
        Random rand = new Random();
        if (wandColor != null) {
            color1 = wandColor;
            color2 = wandColor.mixColors(new Color[]{color1, Color.WHITE});
        } else {
            if (color1 == null) {
                color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
            }
            if (color2 == null) {
                color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
            }
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }
}

