/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MineSpell
extends Spell {
    private static final String DEFAULT_MINEABLE = "14,15,16, 56, 73, 74, 21 ,129,153";
    private static final String DEFAULT_MINED = "14,15,263,264,331,331,351,388,406";
    private static final String DEFAULT_DATA = "0 ,0 ,0  ,0  ,0  ,0  ,4  ,0  ,1";
    private static final int DEFAULT_MAX_RECURSION = 16;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        ArrayList<Material> mineableMaterials = new ArrayList<Material>();
        mineableMaterials.addAll(csv.parseMaterials(DEFAULT_MINEABLE));
        if (!this.isMineable(target, mineableMaterials)) {
            this.sendMessage("Can't mine " + target.getType().name().toLowerCase());
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int maxRecursion = parameters.getInteger("recursion_depth", 16);
        BlockList minedBlocks = new BlockList();
        Material mineMaterial = target.getType();
        this.mine(target, mineMaterial, minedBlocks, maxRecursion);
        World world = this.player.getWorld();
        ArrayList<Material> minedMaterials = new ArrayList<Material>();
        minedMaterials.addAll(csv.parseMaterials(DEFAULT_MINED));
        List<Integer> minedData = csv.parseIntegers(DEFAULT_DATA);
        int index = mineableMaterials.indexOf(mineMaterial);
        mineMaterial = (Material)minedMaterials.get(index);
        byte data = (byte)minedData.get(index).intValue();
        Location itemDrop = new Location(world, (double)target.getX(), (double)target.getY(), (double)target.getZ(), 0.0f, 0.0f);
        ItemStack items = new ItemStack(mineMaterial, minedBlocks.size(), 0, Byte.valueOf(data));
        this.player.getWorld().dropItemNaturally(itemDrop, items);
        this.castMessage("Mined " + minedBlocks.size() + " blocks of " + mineMaterial.name().toLowerCase());
        return SpellResult.SUCCESS;
    }

    protected void mine(Block block, Material fillMaterial, BlockList minedBlocks, int maxRecursion) {
        this.mine(block, fillMaterial, minedBlocks, maxRecursion, 0);
    }

    protected void mine(Block block, Material fillMaterial, BlockList minedBlocks, int maxRecursion, int rDepth) {
        minedBlocks.add(block);
        block.setType(Material.AIR);
        if (rDepth < maxRecursion) {
            this.tryMine(block.getRelative(BlockFace.NORTH), fillMaterial, minedBlocks, maxRecursion, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.WEST), fillMaterial, minedBlocks, maxRecursion, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.SOUTH), fillMaterial, minedBlocks, maxRecursion, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.EAST), fillMaterial, minedBlocks, maxRecursion, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.UP), fillMaterial, minedBlocks, maxRecursion, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.DOWN), fillMaterial, minedBlocks, maxRecursion, rDepth + 1);
        }
    }

    protected void tryMine(Block target, Material fillMaterial, BlockList minedBlocks, int maxRecursion, int rDepth) {
        if (target.getType() != fillMaterial || minedBlocks.contains(target)) {
            return;
        }
        this.mine(target, fillMaterial, minedBlocks, maxRecursion, rDepth);
    }

    public boolean isMineable(Block block, List<Material> mineableMaterials) {
        if (block.getType() == Material.AIR) {
            return false;
        }
        return mineableMaterials.contains(block.getType());
    }
}

