/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class IterateSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        int timeToLive = parameters.getInt("undo", 0);
        boolean incrementData = parameters.getBoolean("increment_data", false);
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target) || !this.hasBuildPermission(this.player.getLocation())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int iterateBlocks = (int)this.player.getLocation().distance(target.getLocation());
        if (iterateBlocks <= 0) {
            return SpellResult.NO_TARGET;
        }
        Vector targetLoc = new Vector(target.getX(), target.getY(), target.getZ());
        Vector playerLoc = new Vector(this.player.getLocation().getX(), this.player.getLocation().getY() + 1.0, this.player.getLocation().getZ());
        Vector aim = targetLoc;
        aim.subtract(playerLoc);
        aim.normalize();
        targetLoc = playerLoc;
        targetLoc.add(aim);
        targetLoc.add(aim);
        Material material = Material.DIRT;
        byte data = 0;
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = IterateSpell.getItemData(buildWith);
        }
        BlockList iteratedBlocks = new BlockList();
        int i = 0;
        while (i < iterateBlocks) {
            Block currentTarget = target.getWorld().getBlockAt(targetLoc.getBlockX(), targetLoc.getBlockY(), targetLoc.getBlockZ());
            if (currentTarget.getType() == Material.AIR) {
                iteratedBlocks.add(currentTarget);
                if (incrementData) {
                    data = (byte)(i > 15 ? 15 : (byte)i);
                }
                currentTarget.setType(material);
                currentTarget.setData(data);
                Location effectLocation = currentTarget.getLocation();
                effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, material.getId());
            }
            targetLoc.add(aim);
            ++i;
        }
        if (iteratedBlocks.size() > 0) {
            if (timeToLive == 0) {
                this.spells.addToUndoQueue(this.player, iteratedBlocks);
            } else {
                iteratedBlocks.setTimeToLive(timeToLive);
                this.spells.scheduleCleanup(this.player.getName(), iteratedBlocks);
            }
        }
        this.castMessage("Filled " + iteratedBlocks.size() + " blocks");
        return SpellResult.SUCCESS;
    }

    public boolean usesMaterial() {
        return true;
    }
}

