/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.SimpleBlockAction;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class FrostSpell
extends Spell {
    private static final int DEFAULT_RADIUS = 2;
    private static final int DEFAULT_TIME_TO_LIVE = 60000;
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFALT_ENTITY_DAMAGE = 10;
    private static final int DEFAULT_SLOWNESS = 1;
    private static final int DEFAULT_DURATION = 200;
    private static final int maxEffectRange = 16;
    private static final int effectSpeed = 1;
    private static final float particleData = 0.1f;
    private static final int effectPeriod = 2;
    private static final int particleCount = 8;

    public SpellResult onCast(ConfigurationNode parameters) {
        Entity targetEntity;
        this.noTargetThrough(Material.WATER);
        this.noTargetThrough(Material.STATIONARY_WATER);
        int effectRange = Math.min(this.getMaxRange(), 16);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effectTrail = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        effectTrail.setParticleType(ParticleType.SNOWBALL_POOF);
        effectTrail.setParticleCount(8);
        effectTrail.setEffectData(0.1f);
        effectTrail.setParticleOffset(0.2f, 0.2f, 0.2f);
        effectTrail.setSpeed(1.0f);
        effectTrail.setPeriod(2);
        effectTrail.start();
        Target target = this.getTarget();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int playerDamage = parameters.getInteger("player_damage", 1);
        int entityDamage = parameters.getInteger("entity_damage", 10);
        int defaultRadius = parameters.getInteger("radius", 2);
        int timeToLive = parameters.getInt("duration", 60000);
        int slowness = parameters.getInt("slowness", 1);
        int slownessDuration = parameters.getInt("slowness_duration", 200);
        if (target.isEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (slowness > 0) {
                PotionEffect effect = new PotionEffect(PotionEffectType.SLOW, slownessDuration, slowness, false);
                li.addPotionEffect(effect);
            }
            if (li instanceof Player) {
                li.damage((double)playerDamage, (Entity)this.player);
            } else {
                li.damage((double)entityDamage, (Entity)this.player);
            }
        }
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", defaultRadius);
        radius = (int)(this.playerSpells.getPowerMultiplier() * (float)radius);
        FrostAction action = new FrostAction();
        if (radius <= 1) {
            action.perform(target.getBlock());
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        BlockList frozenBlocks = action.getBlocks();
        frozenBlocks.setTimeToLive(timeToLive);
        this.spells.scheduleCleanup(this.player.getName(), frozenBlocks);
        this.castMessage("Frosted " + action.getBlocks().size() + " blocks");
        this.spells.updateBlock(target.getBlock());
        return SpellResult.SUCCESS;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FrostAction
    extends SimpleBlockAction {
        public SpellResult perform(Block block) {
            if (block.getType() == Material.AIR || block.getType() == Material.SNOW) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.SNOW;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                material = Material.ICE;
            } else if (block.getType() == Material.LAVA) {
                material = Material.COBBLESTONE;
            } else if (block.getType() == Material.STATIONARY_LAVA) {
                material = Material.OBSIDIAN;
            } else if (block.getType() == Material.FIRE) {
                material = Material.AIR;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            block.setType(material);
            return SpellResult.SUCCESS;
        }
    }
}

