/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.blocks;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.blocks.VolumeBatch;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class FillBatch
extends VolumeBatch {
    private final BlockList filledBlocks = new BlockList();
    private final Material material;
    private final byte data;
    private final World world;
    private final Spell spell;
    private final PlayerSpells playerSpells;
    private String playerName;
    private final int absx;
    private final int absy;
    private final int absz;
    private final int dx;
    private final int dy;
    private final int dz;
    private final int x;
    private final int y;
    private final int z;
    private int ix = 0;
    private int iy = 0;
    private int iz = 0;

    public FillBatch(Spell spell, Location p1, Location p2, Material material, byte data) {
        super(spell.getPlayerSpells().getMaster(), p1.getWorld().getName());
        this.material = material;
        this.data = data;
        this.spell = spell;
        this.playerSpells = spell.getPlayerSpells();
        this.playerName = this.playerSpells.getPlayer().getName();
        this.world = this.playerSpells.getPlayer().getWorld();
        int deltax = p2.getBlockX() - p1.getBlockX();
        int deltay = p2.getBlockY() - p1.getBlockY();
        int deltaz = p2.getBlockZ() - p1.getBlockZ();
        this.absx = Math.abs(deltax) + 1;
        this.absy = Math.abs(deltay) + 1;
        this.absz = Math.abs(deltaz) + 1;
        this.dx = (int)Math.signum(deltax);
        this.dy = (int)Math.signum(deltay);
        this.dz = (int)Math.signum(deltaz);
        this.x = p1.getBlockX();
        this.y = p1.getBlockY();
        this.z = p1.getBlockZ();
    }

    public boolean checkDimension(int maxDimension) {
        return maxDimension <= 0 || this.absx <= maxDimension && this.absy <= maxDimension && this.absz <= maxDimension;
    }

    public boolean checkVolume(int maxVolume) {
        return maxVolume <= 0 || this.absx * this.absy * this.absz <= maxVolume;
    }

    public int process(int maxBlocks) {
        int processedBlocks = 0;
        boolean updated = false;
        while (processedBlocks <= maxBlocks && this.ix < this.absx) {
            Block block = this.world.getBlockAt(this.x + this.ix * this.dx, this.y + this.iy * this.dy, this.z + this.iz * this.dz);
            if (!block.getChunk().isLoaded()) {
                block.getChunk().load();
                return processedBlocks;
            }
            ++processedBlocks;
            if (this.playerSpells.hasBuildPermission(block)) {
                if (!updated) {
                    this.spells.updateBlock(this.world.getName(), this.x, this.y, this.z);
                }
                this.filledBlocks.add(block);
                block.setType(this.material);
                block.setData(this.data);
            }
            ++this.iy;
            if (this.iy < this.absy) continue;
            this.iy = 0;
            ++this.iz;
            if (this.iz < this.absz) continue;
            this.iz = 0;
            ++this.ix;
        }
        if (this.ix >= this.absx) {
            this.finish();
        }
        return processedBlocks;
    }

    protected void finish() {
        super.finish();
        this.spells.addToUndoQueue(this.playerName, this.filledBlocks);
        this.spell.castMessage("Filled " + this.getXSize() + "x" + this.getYSize() + "x" + this.getZSize() + " area with " + this.material.name().toLowerCase());
    }

    public int getXSize() {
        return this.absx;
    }

    public int getYSize() {
        return this.absy;
    }

    public int getZSize() {
        return this.absz;
    }
}

