/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WandOrganizer {
    private final Wand wand;
    private int currentInventoryIndex = 0;
    private int currentInventoryCount = 0;
    private Inventory currentInventory = null;

    public WandOrganizer(Wand wand) {
        this.wand = wand;
    }

    protected void nextInventory() {
        ++this.currentInventoryIndex;
        this.currentInventoryCount = 0;
        this.currentInventory = this.wand.getInventoryByIndex(this.currentInventoryIndex);
    }

    protected void addToInventory(ItemStack itemStack) {
        HashMap result;
        if (this.currentInventoryCount > this.currentInventory.getSize() - 20) {
            this.nextInventory();
        }
        if ((result = this.currentInventory.addItem(new ItemStack[]{itemStack})).size() > 0) {
            this.nextInventory();
            for (ItemStack skipped : result.values()) {
                this.currentInventory.addItem(new ItemStack[]{skipped});
                ++this.currentInventoryCount;
            }
        } else {
            ++this.currentInventoryCount;
        }
    }

    public void organize() {
        HashSet<String> hotbarSpellNames = new HashSet<String>();
        HashSet<String> hotbarMaterialNames = new HashSet<String>();
        Inventory hotbar = this.wand.getHotbar();
        int hotbarSize = 9;
        int i = 0;
        while (i < hotbarSize) {
            ItemStack hotbarItem = hotbar.getItem(i);
            if (hotbarItem != null && hotbarItem.getType() != Material.AIR) {
                String spellName = Wand.getSpell(hotbarItem);
                if (spellName != null) {
                    hotbarSpellNames.add(spellName);
                } else {
                    String materialKey = Wand.getMaterialKey(hotbarItem);
                    if (materialKey != null) {
                        hotbarMaterialNames.add(materialKey);
                    }
                }
            }
            ++i;
        }
        Spells master = this.wand.getMaster();
        HashMap<String, TreeSet<String>> groupedSpells = new HashMap<String, TreeSet<String>>();
        Set<String> spells = this.wand.getSpells();
        for (String spellName : spells) {
            TreeSet<String> spellList;
            Spell spell = master.getSpell(spellName);
            if (spell == null || hotbarSpellNames.contains(spellName)) continue;
            String category = spell.getCategory();
            if (category == null || category.length() == 0) {
                category = "default";
            }
            if ((spellList = (TreeSet<String>)groupedSpells.get(category)) == null) {
                spellList = new TreeSet<String>();
                groupedSpells.put(category, spellList);
            }
            spellList.add(spellName);
        }
        Set<String> materials = this.wand.getMaterialNames();
        for (String hotbarItemName : hotbarMaterialNames) {
            materials.remove(hotbarItemName);
        }
        this.wand.clearInventories();
        this.currentInventoryIndex = 0;
        this.currentInventoryCount = 0;
        this.currentInventory = this.wand.getInventoryByIndex(this.currentInventoryIndex);
        for (Collection spellGroup : groupedSpells.values()) {
            if (this.currentInventoryCount > 8) {
                this.nextInventory();
            }
            for (String spellName : spellGroup) {
                this.addToInventory(this.wand.createSpellItem(spellName));
            }
        }
        if (materials.size() > 0) {
            this.nextInventory();
            for (String materialName : materials) {
                this.addToInventory(this.wand.createMaterialItem(materialName));
            }
        }
    }
}

