/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;

public class ProjectileSpell
extends Spell {
    int defaultSize = 1;

    public SpellResult onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        size = (int)(this.playerSpells.getPowerMultiplier() * (float)size);
        boolean useFire = parameters.getBoolean("fire", true);
        String projectileClass = parameters.getString("projectile", "Fireball");
        try {
            Class<?> projectileType = Class.forName("org.bukkit.entity." + projectileClass);
            Projectile projectile = this.player.launchProjectile(projectileType);
            projectile.setShooter((LivingEntity)this.player);
            if (projectile instanceof Fireball) {
                Fireball fireball = (Fireball)projectile;
                fireball.setIsIncendiary(useFire);
                fireball.setYield((float)size);
            }
        }
        catch (Exception ex) {
            this.sendMessage("Unknown projectile class " + projectileClass);
            return SpellResult.FAILURE;
        }
        return SpellResult.SUCCESS;
    }

    public void onLoadTemplate(ConfigurationNode node) {
        this.disableTargeting();
    }
}

