/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.EffectRing;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class PotionEffectSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        PotionEffectType[] effectTypes;
        Location effectLocation;
        Player targetEntity = null;
        String targetType = parameters.getString("target", "other");
        if (!targetType.equals("self")) {
            this.targetEntity(LivingEntity.class);
            Target target = this.getTarget();
            if (target != null && target.isEntity() && target.getEntity() instanceof LivingEntity) {
                targetEntity = (LivingEntity)target.getEntity();
            }
        }
        if (targetEntity == null && !targetType.equals("other")) {
            targetEntity = this.player;
        }
        if (targetEntity == null) {
            return SpellResult.NO_TARGET;
        }
        ParticleType particleType = ParticleType.fromName(parameters.getString("particle", ""), ParticleType.INSTANT_SPELL);
        if (targetEntity == this.player) {
            effectLocation = this.player.getEyeLocation();
            EffectRing effect = new EffectRing((Plugin)this.spells.getPlugin(), effectLocation, 4, 8);
            effect.setParticleType(particleType);
            effect.setParticleCount(8);
            effect.setEffectSpeed(2.0f);
            effect.setInvert(true);
            effect.start();
        } else {
            effectLocation = this.player.getEyeLocation();
            Vector effectDirection = effectLocation.getDirection();
            EffectTrail effect = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, 32);
            effect.setParticleType(particleType);
            effect.setParticleCount(8);
            effect.setEffectSpeed(2.0f);
            effect.setSpeed(3.0f);
            effect.start();
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        PotionEffectType[] potionEffectTypeArray = effectTypes = PotionEffectType.values();
        int n = effectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName;
            PotionEffectType effectType = potionEffectTypeArray[n2];
            if (effectType != null && parameters.containsKey(typeName = effectType.getName().toLowerCase())) {
                String value = parameters.getString(typeName);
                String[] pieces = value.split(",");
                Integer ticks = Integer.parseInt(pieces[0]);
                Integer power = 1;
                if (pieces.length > 0) {
                    power = Integer.parseInt(pieces[1]);
                }
                PotionEffect effect = new PotionEffect(effectType, ticks.intValue(), power.intValue(), true);
                effects.add(effect);
            }
            ++n2;
        }
        targetEntity.addPotionEffects(effects);
        return SpellResult.SUCCESS;
    }
}

