/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.blocks.ConstructBatch;
import com.elmakers.mine.bukkit.plugins.magic.blocks.ConstructionType;
import com.elmakers.mine.bukkit.utilities.EffectUtils;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class ConstructSpell
extends Spell {
    private ConstructionType defaultConstructionType = ConstructionType.SPHERE;
    private int defaultRadius = 2;
    private int timeToLive = 0;
    private Set<Material> indestructible = null;
    private Block targetBlock = null;

    public SpellResult onCast(ConfigurationNode parameters) {
        String typeString;
        ConstructionType testType;
        this.targetThrough(Material.GLASS);
        Block target = this.getTarget().getBlock();
        if (target == null) {
            this.initializeTargeting(this.player);
            this.noTargetThrough(Material.GLASS);
            target = this.getTarget().getBlock();
        }
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        radius = parameters.getInt("size", radius);
        String targetString = parameters.getString("target", "");
        if (targetString.equals("select")) {
            if (this.targetBlock == null) {
                this.targetBlock = target;
                Location effectLocation = this.targetBlock.getLocation();
                effectLocation.add(0.5, 0.5, 0.5);
                EffectUtils.playEffect(effectLocation, ParticleType.HAPPY_VILLAGER, 0.3f, 0.3f, 0.3f, 1.5f, 10);
                this.castMessage("Cast again to construct");
                this.activate();
                return SpellResult.COST_FREE;
            }
            radius = (int)this.targetBlock.getLocation().distance(target.getLocation());
            target = this.targetBlock;
        }
        if (parameters.containsKey("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        if (!this.hasBuildPermission(target)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Material material = target.getType();
        byte data = target.getData();
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = ConstructSpell.getItemData(buildWith);
        }
        ConstructionType conType = this.defaultConstructionType;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Material materialOverride = parameters.getMaterial("material");
        if (materialOverride != null) {
            material = materialOverride;
            data = 0;
        }
        if ((testType = ConstructionType.parseString(typeString = parameters.getString("type", ""), ConstructionType.UNKNOWN)) != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        this.fillArea(target, radius, material, data, !hollow, conType);
        this.deactivate();
        return SpellResult.SUCCESS;
    }

    public void fillArea(Block target, int radius, Material material, byte data, boolean fill, ConstructionType type) {
        ConstructBatch batch = new ConstructBatch(this, target.getLocation(), type, radius, fill, material, data, this.indestructible);
        if (this.timeToLive > 0) {
            batch.setTimeToLive(this.timeToLive);
        }
        this.spells.addPendingBlockBatch(batch);
    }

    public void onLoadTemplate(ConfigurationNode properties) {
        this.timeToLive = properties.getInt("undo", this.timeToLive);
        this.indestructible = properties.getMaterials("indestructible", "");
    }

    public boolean usesMaterial() {
        return true;
    }

    public void onDeactivate() {
        this.targetBlock = null;
    }

    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.sendMessage("Cancelled construct");
            this.targetBlock = null;
            return true;
        }
        return false;
    }
}

