/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.WandLevel;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.TreeSpecies;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wand
implements CostReducer {
    private static final int inventorySize = 27;
    private static final int hotbarSize = 9;
    private ItemStack item;
    private Spells spells;
    private PlayerSpells activePlayer;
    private String id;
    private Inventory hotbar = InventoryUtils.createInventory(null, 9, "Wand");
    private List<Inventory> inventories = new ArrayList<Inventory>();
    private String activeSpell = "";
    private String activeMaterial = "";
    private String wandName = "";
    private String description = "";
    private String owner = "";
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private float power = 0.0f;
    private boolean hasInventory = false;
    private boolean modifiable = true;
    private int uses = 0;
    private int xp = 0;
    private int xpRegeneration = 0;
    private int xpMax = 50;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private int effectColor = 0;
    private float defaultWalkSpeed = 0.2f;
    private float defaultFlySpeed = 0.1f;
    private float speedIncrease = 0.0f;
    private int storedXpLevel = 0;
    private int storedXp = 0;
    private float storedXpProgress = 0.0f;
    private static DecimalFormat floatFormat = new DecimalFormat("#.###");
    public static Material WandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = Material.WOOD_SWORD;
    public static Material EraseMaterial = Material.SULPHUR;
    public static Material CopyMaterial = Material.PUMPKIN_SEEDS;
    protected static Map<String, ConfigurationNode> wandTemplates = new HashMap<String, ConfigurationNode>();
    private static final String propertiesFileName = "wands.yml";
    private static final String propertiesFileNameDefaults = "wands.defaults.yml";
    int openInventoryPage = 0;
    boolean inventoryIsOpen = false;

    private Wand() {
    }

    public Wand(Spells spells) {
        this();
        this.spells = spells;
        this.item = new ItemStack(WandMaterial);
        this.item = InventoryUtils.getCopy(this.item);
        ItemMeta itemMeta = this.item.getItemMeta();
        this.item.setItemMeta(itemMeta);
        InventoryUtils.addGlow(this.item);
        this.id = UUID.randomUUID().toString();
        this.wandName = Messages.get("wand.default_name");
        this.updateName();
        this.saveState();
    }

    public Wand(Spells spells, ItemStack item) {
        this();
        this.item = item;
        this.spells = spells;
        this.loadState();
    }

    public void setActiveSpell(String activeSpell) {
        this.activeSpell = activeSpell;
        this.updateName();
        this.updateInventoryNames(true);
        this.saveState();
    }

    public void setActiveMaterial(Material material, byte data) {
        String materialKey = "";
        materialKey = material == CopyMaterial ? "-1:0" : (material == EraseMaterial ? "0:0" : String.valueOf(material.getId()) + ":" + data);
        this.setActiveMaterial(materialKey);
    }

    protected void setActiveMaterial(String materialKey) {
        this.activeMaterial = materialKey;
        this.updateName();
        this.updateActiveMaterial();
        this.updateInventoryNames(true);
        this.saveState();
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public int getXpMax() {
        return this.xpMax;
    }

    public int getExperience() {
        return this.xp;
    }

    public void removeExperience(int amount) {
        this.xp = Math.max(0, this.xp - amount);
        this.updateMana();
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    @Override
    public float getCostReduction() {
        return this.costReduction;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public boolean usesMana() {
        return this.xpMax > 0 && this.xpRegeneration > 0;
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public float getPower() {
        return this.power;
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    public int getUses() {
        return this.uses;
    }

    public String getName() {
        return this.wandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    protected void setName(String name) {
        this.wandName = name;
        this.updateName();
    }

    protected void setDescription(String description) {
        this.description = description;
        this.updateLore();
    }

    protected void takeOwnership(Player player) {
        this.owner = player.getName();
    }

    public void takeOwnership(Player player, String name, boolean updateDescription) {
        this.setName(name);
        this.takeOwnership(player);
        if (updateDescription) {
            this.setDescription(Messages.get("wand.owner_description", "$name's Wand").replace("$name", this.owner));
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    protected List<Inventory> getAllInventories() {
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    protected Set<String> getSpells() {
        return this.getSpells(false);
    }

    protected Set<String> getSpells(boolean includePositions) {
        TreeSet<String> spellNames = new TreeSet<String>();
        List<Inventory> allInventories = this.getAllInventories();
        int index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int i = 0;
            while (i < items.length) {
                if (items[i] != null && !Wand.isWand(items[i]) && Wand.isSpell(items[i])) {
                    String spellName = Wand.getSpell(items[i]);
                    if (includePositions) {
                        spellName = String.valueOf(spellName) + "@" + index;
                    }
                    spellNames.add(spellName);
                }
                ++index;
                ++i;
            }
        }
        return spellNames;
    }

    protected String getSpellString() {
        return StringUtils.join(this.getSpells(true), (String)"|");
    }

    protected Set<String> getMaterialNames() {
        return this.getMaterialNames(false);
    }

    protected String getMaterialKey(ItemStack itemStack) {
        return this.getMaterialKey(itemStack, null);
    }

    protected String getMaterialKey(ItemStack itemStack, Integer index) {
        if (itemStack == null || Wand.isSpell(itemStack) || Wand.isWand(itemStack)) {
            return null;
        }
        Material material = itemStack.getType();
        if (material == Material.AIR) {
            return null;
        }
        String materialKey = String.valueOf(material.getId()) + ":" + itemStack.getData().getData();
        if (material == EraseMaterial) {
            materialKey = "0:0";
        } else if (material == CopyMaterial) {
            materialKey = "-1:0";
        }
        if (index != null) {
            materialKey = String.valueOf(materialKey) + "@" + index;
        }
        return materialKey;
    }

    protected Set<String> getMaterialNames(boolean includePositions) {
        TreeSet<String> materialNames = new TreeSet<String>();
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        Integer index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int i = 0;
            while (i < items.length) {
                String materialKey = this.getMaterialKey(items[i], includePositions ? index : null);
                if (materialKey != null) {
                    materialNames.add(materialKey);
                }
                index = index + 1;
                ++i;
            }
        }
        return materialNames;
    }

    protected String getMaterialString() {
        return StringUtils.join(this.getMaterialNames(true), (String)"|");
    }

    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 0) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    protected void addToInventory(ItemStack itemStack) {
        List<Inventory> allInventories = this.getAllInventories();
        boolean added = false;
        Integer selectedItem = null;
        if (this.activePlayer != null && this.activePlayer.getPlayer() != null) {
            selectedItem = this.activePlayer.getPlayer().getInventory().getHeldItemSlot();
            this.hotbar.setItem(selectedItem.intValue(), this.item);
        }
        for (Inventory inventory : allInventories) {
            HashMap returned = inventory.addItem(new ItemStack[]{itemStack});
            if (returned.size() != 0) continue;
            added = true;
            break;
        }
        if (!added) {
            Inventory newInventory = InventoryUtils.createInventory(null, 27, "Wand");
            newInventory.addItem(new ItemStack[]{itemStack});
            this.inventories.add(newInventory);
        }
        if (selectedItem != null) {
            this.hotbar.setItem(selectedItem.intValue(), null);
        }
    }

    protected Inventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(InventoryUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected Inventory getInventory(Integer slot) {
        Inventory inventory = this.hotbar;
        if (slot >= 9) {
            int inventoryIndex = (slot - 9) / 27;
            inventory = this.getInventoryByIndex(inventoryIndex);
        }
        return inventory;
    }

    protected int getInventorySlot(Integer slot) {
        if (slot < 9) {
            return slot;
        }
        return (slot - 9) % 27;
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        Inventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot.intValue());
        inventory.setItem(slot.intValue(), itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    protected void parseInventoryStrings(String spellString, String materialString) {
        String[] materialNames;
        String[] spellNames;
        this.hotbar.clear();
        this.inventories.clear();
        String[] stringArray = spellNames = StringUtils.split((String)spellString, (String)"|");
        int n = spellNames.length;
        int n2 = 0;
        while (n2 < n) {
            String spellName = stringArray[n2];
            String[] pieces = spellName.split("@");
            Integer slot = this.parseSlot(pieces);
            ItemStack itemStack = this.createSpellItem(pieces[0]);
            if (itemStack != null) {
                this.addToInventory(itemStack, slot);
            }
            ++n2;
        }
        String[] stringArray2 = materialNames = StringUtils.split((String)materialString, (String)"|");
        int n3 = materialNames.length;
        n = 0;
        while (n < n3) {
            String materialName = stringArray2[n];
            String[] pieces = materialName.split("@");
            Integer slot = this.parseSlot(pieces);
            ItemStack itemStack = this.createMaterialItem(pieces[0]);
            this.addToInventory(itemStack, slot);
            ++n;
        }
        this.hasInventory = spellNames.length + materialNames.length > 1;
    }

    protected ItemStack createMaterialItem(String materialKey) {
        String[] nameParts = StringUtils.split((String)materialKey, (String)":");
        int typeId = Integer.parseInt(nameParts[0]);
        if (typeId == 0) {
            typeId = EraseMaterial.getId();
        } else if (typeId == -1) {
            typeId = CopyMaterial.getId();
        }
        byte dataId = nameParts.length > 1 ? Byte.parseByte(nameParts[1]) : (byte)0;
        return this.createMaterialItem(typeId, dataId);
    }

    protected ItemStack createSpellItem(String spellName) {
        Spell spell = this.spells.getSpell(spellName);
        if (spell == null) {
            return null;
        }
        if (spell.getMaterial() == null) {
            this.spells.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
        }
        ItemStack itemStack = null;
        ItemStack originalItemStack = null;
        try {
            originalItemStack = new ItemStack(spell.getMaterial(), 1);
            itemStack = InventoryUtils.getCopy(originalItemStack);
        }
        catch (Exception ex) {
            itemStack = null;
        }
        if (itemStack == null) {
            this.spells.getPlugin().getLogger().warning("Unable to create spell icon with material " + spell.getMaterial().name());
            return originalItemStack;
        }
        this.updateSpellName(itemStack, spell, true);
        return itemStack;
    }

    protected ItemStack createMaterialItem(int typeId, byte dataId) {
        if (typeId == 0) {
            typeId = EraseMaterial.getId();
        } else if (typeId == -1) {
            typeId = CopyMaterial.getId();
        }
        ItemStack originalItemStack = new ItemStack(typeId, 1, 0, Byte.valueOf(dataId));
        ItemStack itemStack = InventoryUtils.getCopy(originalItemStack);
        if (itemStack == null) {
            this.spells.getPlugin().getLogger().warning("Unable to create material icon for id " + typeId + ": " + originalItemStack.getType());
            return originalItemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (typeId == EraseMaterial.getId()) {
            typeId = EraseMaterial.getId();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Messages.get("wand.erase_material_description"));
            meta.setLore(lore);
        } else if (typeId == CopyMaterial.getId()) {
            typeId = EraseMaterial.getId();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Messages.get("wand.copy_material_description"));
            meta.setLore(lore);
        } else {
            ArrayList<String> lore = new ArrayList<String>();
            Material material = Material.getMaterial((int)typeId);
            if (material != null) {
                lore.add(ChatColor.GRAY + this.getMaterialName(material, dataId));
            }
            lore.add(ChatColor.LIGHT_PURPLE + Messages.get("wand.building_material_description"));
            meta.setLore(lore);
        }
        meta.setDisplayName(this.getActiveWandName(Material.getMaterial((int)typeId)));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    protected void saveState() {
        Object wandNode = InventoryUtils.createNode(this.item, "wand");
        InventoryUtils.setMeta(wandNode, "id", this.id);
        String wandMaterials = this.getMaterialString();
        String wandSpells = this.getSpellString();
        InventoryUtils.setMeta(wandNode, "materials", wandMaterials);
        InventoryUtils.setMeta(wandNode, "spells", wandSpells);
        InventoryUtils.setMeta(wandNode, "active_spell", this.activeSpell);
        InventoryUtils.setMeta(wandNode, "active_material", this.activeMaterial);
        InventoryUtils.setMeta(wandNode, "name", this.wandName);
        InventoryUtils.setMeta(wandNode, "description", this.description);
        InventoryUtils.setMeta(wandNode, "owner", this.owner);
        InventoryUtils.setMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction));
        InventoryUtils.setMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction));
        InventoryUtils.setMeta(wandNode, "power", floatFormat.format(this.power));
        InventoryUtils.setMeta(wandNode, "protection", floatFormat.format(this.damageReduction));
        InventoryUtils.setMeta(wandNode, "protection_physical", floatFormat.format(this.damageReductionPhysical));
        InventoryUtils.setMeta(wandNode, "protection_projectiles", floatFormat.format(this.damageReductionProjectiles));
        InventoryUtils.setMeta(wandNode, "protection_falling", floatFormat.format(this.damageReductionFalling));
        InventoryUtils.setMeta(wandNode, "protection_fire", floatFormat.format(this.damageReductionFire));
        InventoryUtils.setMeta(wandNode, "protection_explosions", floatFormat.format(this.damageReductionExplosions));
        InventoryUtils.setMeta(wandNode, "haste", floatFormat.format(this.speedIncrease));
        InventoryUtils.setMeta(wandNode, "xp", Integer.toString(this.xp));
        InventoryUtils.setMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration));
        InventoryUtils.setMeta(wandNode, "xp_max", Integer.toString(this.xpMax));
        InventoryUtils.setMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration));
        InventoryUtils.setMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration));
        InventoryUtils.setMeta(wandNode, "uses", Integer.toString(this.uses));
        InventoryUtils.setMeta(wandNode, "has_inventory", Integer.toString(this.hasInventory ? 1 : 0));
        InventoryUtils.setMeta(wandNode, "modifiable", Integer.toString(this.modifiable ? 1 : 0));
        InventoryUtils.setMeta(wandNode, "effect_color", Integer.toString(this.effectColor, 16));
    }

    protected void loadState() {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            this.spells.getPlugin().getLogger().warning("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        this.id = InventoryUtils.getMeta(wandNode, "id");
        this.id = this.id == null || this.id.length() == 0 ? UUID.randomUUID().toString() : this.id;
        this.wandName = InventoryUtils.getMeta(wandNode, "name", this.wandName);
        this.description = InventoryUtils.getMeta(wandNode, "description", this.description);
        this.owner = InventoryUtils.getMeta(wandNode, "owner", this.owner);
        String wandMaterials = InventoryUtils.getMeta(wandNode, "materials", "");
        String wandSpells = InventoryUtils.getMeta(wandNode, "spells", "");
        this.parseInventoryStrings(wandSpells, wandMaterials);
        this.activeSpell = InventoryUtils.getMeta(wandNode, "active_spell", this.activeSpell);
        this.activeMaterial = InventoryUtils.getMeta(wandNode, "active_material", this.activeMaterial);
        this.costReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction)));
        this.cooldownReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction)));
        this.power = Float.parseFloat(InventoryUtils.getMeta(wandNode, "power", floatFormat.format(this.power)));
        this.damageReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection", floatFormat.format(this.damageReduction)));
        this.damageReductionPhysical = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_physical", floatFormat.format(this.damageReductionPhysical)));
        this.damageReductionProjectiles = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_projectiles", floatFormat.format(this.damageReductionProjectiles)));
        this.damageReductionFalling = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_falling", floatFormat.format(this.damageReductionFalling)));
        this.damageReductionFire = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_fire", floatFormat.format(this.damageReductionFire)));
        this.damageReductionExplosions = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_explosions", floatFormat.format(this.damageReductionExplosions)));
        this.speedIncrease = Float.parseFloat(InventoryUtils.getMeta(wandNode, "haste", floatFormat.format(this.speedIncrease)));
        this.xp = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp", Integer.toString(this.xp)));
        this.xpRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration)));
        this.xpMax = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_max", Integer.toString(this.xpMax)));
        this.healthRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration)));
        this.hungerRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration)));
        this.uses = Integer.parseInt(InventoryUtils.getMeta(wandNode, "uses", Integer.toString(this.uses)));
        this.hasInventory = Integer.parseInt(InventoryUtils.getMeta(wandNode, "has_inventory", this.hasInventory ? "1" : "0")) != 0;
        this.modifiable = Integer.parseInt(InventoryUtils.getMeta(wandNode, "modifiable", this.modifiable ? "1" : "0")) != 0;
        this.effectColor = Integer.parseInt(InventoryUtils.getMeta(wandNode, "effect_color", Integer.toString(this.effectColor, 16)), 16);
        this.speedIncrease = Math.min(WandLevel.maxSpeedIncrease, this.speedIncrease);
    }

    protected void describe(CommandSender sender) {
        String[] keys;
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            sender.sendMessage("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        ChatColor wandColor = this.modifiable ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.wandName);
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.WHITE + this.owner);
        } else {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.WHITE + "(No Owner)");
        }
        String[] stringArray = keys = new String[]{"active_spell", "active_material", "xp", "xp_regeneration", "xp_max", "health_regeneration", "hunger_regeneration", "uses", "cost_reduction", "cooldown_reduction", "power", "protection", "protection_physical", "protection_projectiles", "protection_falling", "protection_fire", "protection_explosions", "haste", "has_inventory", "modifiable", "effect_color", "materials", "spells"};
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = InventoryUtils.getMeta(wandNode, key);
            if (value != null && value.length() > 0) {
                sender.sendMessage(String.valueOf(key) + ": " + value);
            }
            ++n2;
        }
    }

    public boolean removeMaterial(Material material, byte data) {
        if (!this.modifiable) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        Integer id = material.getId();
        String materialString = id.toString();
        if ((materialString = String.valueOf(materialString) + ":" + data).equals(this.activeMaterial)) {
            this.activeMaterial = null;
        }
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int index = 0;
            while (index < items.length) {
                ItemStack itemStack = items[index];
                if (itemStack != null && itemStack.getType() != Material.AIR && !Wand.isWand(itemStack) && !Wand.isSpell(itemStack)) {
                    if (itemStack.getType() == material && data == itemStack.getData().getData()) {
                        found = true;
                        inventory.setItem(index, null);
                    } else if (this.activeMaterial == null) {
                        this.activeMaterial = itemStack.getTypeId() + ":" + itemStack.getData().getData();
                    }
                    if (found && this.activeMaterial != null) continue block0;
                }
                ++index;
            }
        }
        this.updateActiveMaterial();
        this.updateInventoryNames(true);
        this.updateName();
        this.updateLore();
        this.saveState();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return found;
    }

    public boolean addMaterial(Material material, byte data, boolean force) {
        return this.addMaterial(material, data, false, force);
    }

    public boolean addMaterial(Material material, byte data) {
        return this.addMaterial(material, data, false, false);
    }

    public boolean hasMaterial(int materialId, byte data) {
        String materialName = String.valueOf(materialId) + ":" + data;
        return this.getMaterialNames().contains(materialName);
    }

    public boolean hasMaterial(Material material, byte data) {
        return this.hasMaterial(material.getId(), data);
    }

    public boolean hasSpell(String spellName) {
        return this.getSpells().contains(spellName);
    }

    public boolean addMaterial(String materialName, boolean makeActive, boolean force) {
        boolean addedNew;
        if (!this.modifiable && !force) {
            return false;
        }
        Integer materialId = null;
        byte data = 0;
        try {
            String[] pieces = materialName.split(":");
            data = pieces.length > 1 ? Byte.parseByte(pieces[1]) : (byte)0;
            materialId = Integer.parseInt(pieces[0]);
        }
        catch (Exception ex) {
            materialId = null;
        }
        if (materialId == null) {
            return false;
        }
        boolean bl = addedNew = !this.hasMaterial(materialId, data);
        if (addedNew) {
            this.addToInventory(this.createMaterialItem(materialId, data));
        }
        if (this.activeMaterial == null || this.activeMaterial.length() == 0 || makeActive) {
            this.activeMaterial = materialName;
        }
        this.updateActiveMaterial();
        this.updateInventoryNames(true);
        this.updateName();
        this.updateLore();
        this.saveState();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        this.hasInventory = this.getSpells().size() + this.getMaterialNames().size() > 1;
        return addedNew;
    }

    public boolean addMaterial(Material material, byte data, boolean makeActive, boolean force) {
        if (!this.modifiable && !force) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        Integer id = material.getId();
        String materialString = id.toString();
        if (material == EraseMaterial) {
            materialString = "0";
        } else if (material == CopyMaterial) {
            materialString = "-1";
        }
        materialString = String.valueOf(materialString) + ":" + data;
        return this.addMaterial(materialString, makeActive, force);
    }

    public boolean removeSpell(String spellName) {
        if (!this.modifiable) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (spellName.equals(this.activeSpell)) {
            this.activeSpell = null;
        }
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int index = 0;
            while (index < items.length) {
                ItemStack itemStack = items[index];
                if (itemStack != null && itemStack.getType() != Material.AIR && !Wand.isWand(itemStack) && Wand.isSpell(itemStack)) {
                    if (Wand.getSpell(itemStack).equals(spellName)) {
                        found = true;
                        inventory.setItem(index, null);
                    } else if (this.activeSpell == null) {
                        this.activeSpell = Wand.getSpell(itemStack);
                    }
                    if (found && this.activeSpell != null) continue block0;
                }
                ++index;
            }
        }
        this.updateInventoryNames(true);
        this.updateName();
        this.updateLore();
        this.saveState();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return found;
    }

    public boolean addSpell(String spellName, boolean makeActive) {
        boolean addedNew;
        if (!this.modifiable) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        boolean bl = addedNew = !this.hasSpell(spellName);
        if (addedNew) {
            this.addToInventory(this.createSpellItem(spellName));
        }
        if (this.activeSpell == null || this.activeSpell.length() == 0 || makeActive) {
            this.activeSpell = spellName;
        }
        this.hasInventory = this.getSpells().size() + this.getMaterialNames().size() > 1;
        this.updateInventoryNames(true);
        this.updateName();
        this.updateLore();
        this.saveState();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return addedNew;
    }

    public boolean addSpell(String spellName) {
        return this.addSpell(spellName, false);
    }

    private String getActiveWandName(Spell spell, String materialName) {
        int remaining;
        ChatColor wandColor = this.modifiable ? ChatColor.AQUA : ChatColor.RED;
        String name = wandColor + this.wandName;
        if (spell != null) {
            if (materialName != null) {
                materialName = materialName.replace('_', ' ');
                name = ChatColor.GOLD + spell.getName() + ChatColor.GRAY + " " + materialName + ChatColor.WHITE + " (" + wandColor + this.wandName + ChatColor.WHITE + ")";
            } else {
                name = ChatColor.GOLD + spell.getName() + ChatColor.WHITE + " (" + wandColor + this.wandName + ChatColor.WHITE + ")";
            }
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            name = String.valueOf(name) + " : " + ChatColor.RED + Messages.get("wand.uses_remaining_brief").replace("$count", Integer.valueOf(remaining).toString());
        }
        return name;
    }

    private String getActiveWandName(Spell spell) {
        String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
        String materialName = null;
        if (spell != null && spell.usesMaterial() && !spell.hasMaterialOverride() && pieces.length > 0 && pieces[0].length() > 0) {
            int materialId = Integer.parseInt(pieces[0]);
            if (materialId == 0) {
                materialName = "erase";
            } else if (materialId == -1) {
                materialName = "copy";
            } else {
                Material material = Material.getMaterial((int)materialId);
                materialName = material.name().toLowerCase();
            }
        }
        return this.getActiveWandName(spell, materialName);
    }

    private String getMaterialName(Material material) {
        return this.getMaterialName(material, (byte)0);
    }

    private String getMaterialName(Material material, byte data) {
        String materialName = null;
        if (material == EraseMaterial) {
            materialName = "erase";
        } else if (material == CopyMaterial) {
            materialName = "copy";
        } else {
            materialName = material.name().toLowerCase();
            if (material == Material.CARPET || material == Material.STAINED_GLASS || material == Material.STAINED_CLAY || material == Material.STAINED_GLASS_PANE || material == Material.WOOL) {
                DyeColor color = DyeColor.getByWoolData((byte)data);
                materialName = String.valueOf(color.name().toLowerCase().replace('_', ' ')) + " " + materialName;
            } else if (material == Material.WOOD || material == Material.LOG || material == Material.SAPLING || material == Material.LEAVES) {
                TreeSpecies treeSpecies = TreeSpecies.getByData((byte)data);
                materialName = String.valueOf(treeSpecies.name().toLowerCase().replace('_', ' ')) + " " + materialName;
            }
        }
        materialName = materialName.replace('_', ' ');
        return materialName;
    }

    private String getActiveWandName(Material material) {
        Spell spell = this.spells.getSpell(this.activeSpell);
        String materialName = null;
        if (spell != null && spell.usesMaterial() && !spell.hasMaterialOverride() && material != null) {
            materialName = this.getMaterialName(material);
        }
        return this.getActiveWandName(spell, materialName);
    }

    private String getActiveWandName() {
        Spell spell = null;
        if (this.hasInventory) {
            spell = this.spells.getSpell(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    public void updateName(boolean isActive) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(isActive ? this.getActiveWandName() : this.wandName);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    private void updateName() {
        this.updateName(true);
    }

    private String getLevelString(String prefix, float amount) {
        String suffix = "";
        suffix = amount >= 1.0f ? Messages.get("wand.enchantment_level_max") : ((double)amount > 0.8 ? Messages.get("wand.enchantment_level_5") : ((double)amount > 0.6 ? Messages.get("wand.enchantment_level_4") : ((double)amount > 0.4 ? Messages.get("wand.enchantment_level_3") : ((double)amount > 0.2 ? Messages.get("wand.enchantment_level_2") : Messages.get("wand.enchantment_level_1")))));
        return String.valueOf(prefix) + " " + suffix;
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor c = chatColorArray[n2];
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
            ++n2;
        }
        int i = 0;
        while (i < tagCount) {
            line = String.valueOf(line) + "</span>";
            ++i;
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    private List<String> getLore() {
        return this.getLore(this.getSpells().size(), this.getMaterialNames().size());
    }

    private List<String> getLore(int spellCount, int materialCount) {
        ArrayList<String> lore = new ArrayList<String>();
        Spell spell = this.spells.getSpell(this.activeSpell);
        if (spell != null && spellCount == 1 && materialCount <= 1) {
            this.addSpellLore(spell, lore);
        } else {
            if (this.description.length() > 0) {
                lore.add(ChatColor.ITALIC + ChatColor.GREEN + this.description);
            }
            lore.add(Messages.get("wand.spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            if (materialCount > 0) {
                lore.add(Messages.get("wand.material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            }
        }
        int remaining = this.getRemainingUses();
        if (remaining > 0) {
            lore.add(ChatColor.RED + Messages.get("wand.uses_remaining").replace("$count", Integer.valueOf(remaining).toString()));
        }
        if (this.xpRegeneration > 0) {
            lore.add(ChatColor.LIGHT_PURPLE + ChatColor.ITALIC + Messages.get("wand.mana_amount").replace("$amount", Integer.valueOf(this.xpMax).toString()));
            lore.add(ChatColor.RESET + ChatColor.LIGHT_PURPLE + this.getLevelString(Messages.get("wand.mana_regeneration"), this.xpRegeneration / 20));
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.cost_reduction"), this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.cooldown_reduction"), this.cooldownReduction));
        }
        if (this.power > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.power"), this.power));
        }
        if (this.speedIncrease > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.haste"), this.speedIncrease / WandLevel.maxSpeedIncrease));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection"), this.damageReduction));
        }
        if (this.damageReduction < 1.0f) {
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_physical"), this.damageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_projectile"), this.damageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_fall"), this.damageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_fire"), this.damageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_blast"), this.damageReductionExplosions));
            }
        }
        if (this.healthRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.health_regeneration"), this.healthRegeneration / 20));
        }
        if (this.hungerRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.hunger_regeneration"), this.hungerRegeneration / 20));
        }
        return lore;
    }

    private void updateLore() {
        ItemMeta meta = this.item.getItemMeta();
        List<String> lore = this.getLore();
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        this.item.setType(enchantable ? EnchantableWandMaterial : WandMaterial);
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(Spells spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return !(item == null || item.getType() != WandMaterial && item.getType() != EnchantableWandMaterial || !InventoryUtils.hasMeta(item, "wand") && !InventoryUtils.hasMeta(item, "magic_wand"));
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && item.getType() != WandMaterial && InventoryUtils.hasMeta(item, "spell");
    }

    public static String getSpell(ItemStack item) {
        if (!Wand.isSpell(item)) {
            return null;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        return InventoryUtils.getMeta(spellNode, "key");
    }

    public void updateInventoryNames(boolean activeNames) {
        ItemStack[] contents;
        if (this.activePlayer == null || !this.isInventoryOpen()) {
            return;
        }
        ItemStack[] itemStackArray = contents = this.activePlayer.getPlayer().getInventory().getContents();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getType() != Material.AIR && !Wand.isWand(item)) {
                this.updateInventoryName(item, activeNames);
            }
            ++n2;
        }
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            Spell spell = this.activePlayer.getSpell(Wand.getSpell(item));
            if (spell != null) {
                this.updateSpellName(item, spell, activeName);
            }
        } else {
            this.updateMaterialName(item, activeName);
        }
    }

    protected void updateSpellName(ItemStack itemStack, Spell spell, boolean activeName) {
        ItemMeta meta = itemStack.getItemMeta();
        if (activeName) {
            meta.setDisplayName(this.getActiveWandName(spell));
        } else {
            meta.setDisplayName(ChatColor.GOLD + spell.getName());
        }
        ArrayList<String> lore = new ArrayList<String>();
        this.addSpellLore(spell, lore);
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        InventoryUtils.addGlow(itemStack);
        Object spellNode = InventoryUtils.createNode(itemStack, "spell");
        InventoryUtils.setMeta(spellNode, "key", spell.getKey());
    }

    protected void updateMaterialName(ItemStack itemStack, boolean activeName) {
        ItemMeta meta = itemStack.getItemMeta();
        if (activeName) {
            meta.setDisplayName(this.getActiveWandName(itemStack.getType()));
        } else {
            meta.setDisplayName(this.getMaterialName(itemStack.getType()));
        }
        itemStack.setItemMeta(meta);
    }

    private void updateInventory() {
        if (this.activePlayer == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.activePlayer.getPlayer() == null) {
            return;
        }
        if (!this.activePlayer.hasStoredInventory()) {
            return;
        }
        Player player = this.activePlayer.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.clear();
        int currentSlot = playerInventory.getHeldItemSlot();
        ItemStack existingHotbar = this.hotbar.getItem(currentSlot);
        if (existingHotbar != null && existingHotbar.getType() != Material.AIR && !Wand.isWand(existingHotbar)) {
            this.addToInventory(existingHotbar);
            this.hotbar.setItem(currentSlot, null);
        }
        playerInventory.setItem(currentSlot, this.item);
        int hotbarSlot = 0;
        while (hotbarSlot < 9) {
            if (hotbarSlot != currentSlot) {
                playerInventory.setItem(hotbarSlot, this.hotbar.getItem(hotbarSlot));
            }
            ++hotbarSlot;
        }
        if (this.openInventoryPage < this.inventories.size()) {
            Inventory inventory = this.inventories.get(this.openInventoryPage);
            ItemStack[] contents = inventory.getContents();
            int i = 0;
            while (i < contents.length) {
                playerInventory.setItem(i + 9, contents[i]);
                ++i;
            }
        }
        this.updateName();
        player.updateInventory();
    }

    protected void addSpellLore(Spell spell, List<String> lore) {
        List<CastingCost> costs;
        String description = spell.getDescription();
        String usage = spell.getUsage();
        if (description != null && description.length() > 0) {
            lore.add(description);
        }
        if (usage != null && usage.length() > 0) {
            lore.add(usage);
        }
        if ((costs = spell.getCosts()) != null) {
            for (CastingCost cost : costs) {
                if (!cost.hasCosts(this)) continue;
                lore.add(ChatColor.YELLOW + Messages.get("wand.costs_description").replace("$description", cost.getFullDescription(this)));
            }
        }
    }

    protected Inventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(InventoryUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    public void saveInventory() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.activePlayer == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.activePlayer.getPlayer() == null) {
            return;
        }
        if (!this.activePlayer.hasStoredInventory()) {
            return;
        }
        Player player = this.activePlayer.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        int i = 0;
        while (i < 9) {
            ItemStack playerItem = playerInventory.getItem(i);
            if (Wand.isWand(playerItem)) {
                playerItem = null;
            }
            this.hotbar.setItem(i, playerItem);
            ++i;
        }
        Inventory openInventory = this.getOpenInventory();
        int i2 = 0;
        while (i2 < openInventory.getSize()) {
            openInventory.setItem(i2, playerInventory.getItem(i2 + 9));
            ++i2;
        }
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    protected void randomize(int level, boolean additive) {
        if (!wandTemplates.containsKey("random")) {
            return;
        }
        if (!additive) {
            this.wandName = Messages.get("wands.random.name", this.wandName);
        }
        WandLevel.randomizeWand(this, additive, level);
    }

    public static Wand createWand(Spells spells, String templateName) {
        Wand wand = new Wand(spells);
        String wandName = Messages.get("wand.default_name");
        String wandDescription = "";
        if ((templateName == null || templateName.length() == 0) && wandTemplates.containsKey("default")) {
            templateName = "default";
        }
        if (templateName != null && templateName.length() > 0) {
            List<Object> materialList;
            if ((templateName.equals("random") || templateName.startsWith("random(")) && wandTemplates.containsKey("random")) {
                int level = 1;
                if (!templateName.equals("random")) {
                    String randomLevel = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
                    level = Integer.parseInt(randomLevel);
                }
                ConfigurationNode randomTemplate = wandTemplates.get("random");
                wand.modifiable = randomTemplate.getBoolean("modifiable", true);
                wand.randomize(level, false);
                return wand;
            }
            if (!wandTemplates.containsKey(templateName)) {
                return null;
            }
            ConfigurationNode wandConfig = wandTemplates.get(templateName);
            wandName = Messages.get("wands." + templateName + ".name", wandName);
            wandDescription = Messages.get("wands." + templateName + ".description", wandDescription);
            List<Object> spellList = wandConfig.getList("spells");
            if (spellList != null) {
                for (Object spellName : spellList) {
                    wand.addSpell((String)spellName);
                }
            }
            if ((materialList = wandConfig.getList("materials")) != null) {
                for (Object materialNameAndData : materialList) {
                    String[] materialParts = StringUtils.split((String)((String)materialNameAndData), (char)':');
                    String materialName = materialParts[0];
                    byte data = 0;
                    if (materialParts.length > 1) {
                        data = Byte.parseByte(materialParts[1]);
                    }
                    if (materialName.equals("erase")) {
                        wand.addMaterial(EraseMaterial, (byte)0, false);
                        continue;
                    }
                    if (materialName.equals("copy") || materialName.equals("clone")) {
                        wand.addMaterial(CopyMaterial, (byte)0, false);
                        continue;
                    }
                    wand.addMaterial(ConfigurationNode.toMaterial(materialName), data, false);
                }
            }
            wand.configureProperties(wandConfig);
        }
        wand.setDescription(wandDescription);
        wand.setName(wandName);
        return wand;
    }

    public void add(Wand other) {
        if (!this.modifiable || !other.modifiable) {
            return;
        }
        this.costReduction = Math.max(this.costReduction, other.costReduction);
        this.power = Math.max(this.power, other.power);
        this.damageReduction = Math.max(this.damageReduction, other.damageReduction);
        this.damageReductionPhysical = Math.max(this.damageReductionPhysical, other.damageReductionPhysical);
        this.damageReductionProjectiles = Math.max(this.damageReductionProjectiles, other.damageReductionProjectiles);
        this.damageReductionFalling = Math.max(this.damageReductionFalling, other.damageReductionFalling);
        this.damageReductionFire = Math.max(this.damageReductionFire, other.damageReductionFire);
        this.damageReductionExplosions = Math.max(this.damageReductionExplosions, other.damageReductionExplosions);
        this.xpRegeneration = Math.max(this.xpRegeneration, other.xpRegeneration);
        this.xpMax = Math.max(this.xpMax, other.xpMax);
        this.xp = Math.max(this.xp, other.xp);
        this.healthRegeneration = Math.max(this.healthRegeneration, other.healthRegeneration);
        this.hungerRegeneration = Math.max(this.hungerRegeneration, other.hungerRegeneration);
        this.speedIncrease = Math.max(this.speedIncrease, other.speedIncrease);
        this.effectColor = Math.max(this.effectColor, other.effectColor);
        this.uses = this.uses == 0 || other.uses == 0 ? 0 : (this.uses += other.uses);
        Set<String> spells = other.getSpells();
        for (String spell : spells) {
            this.addSpell(spell, false);
        }
        Set<String> materials = other.getMaterialNames();
        for (String material : materials) {
            this.addMaterial(material, false, true);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public void configureProperties(ConfigurationNode wandConfig) {
        this.configureProperties(wandConfig, false);
    }

    public void configureProperties(ConfigurationNode wandConfig, boolean safe) {
        this.modifiable = wandConfig.getBoolean("modifiable", this.modifiable);
        float _costReduction = (float)wandConfig.getDouble("cost_reduction", this.costReduction);
        this.costReduction = safe ? Math.max(_costReduction, this.costReduction) : _costReduction;
        float _cooldownReduction = (float)wandConfig.getDouble("cooldown_reduction", this.cooldownReduction);
        this.cooldownReduction = safe ? Math.max(_cooldownReduction, this.cooldownReduction) : _cooldownReduction;
        float _power = (float)wandConfig.getDouble("power", this.power);
        this.power = safe ? Math.max(_power, this.power) : _power;
        float _damageReduction = (float)wandConfig.getDouble("protection", this.damageReduction);
        this.damageReduction = safe ? Math.max(_damageReduction, this.damageReduction) : _damageReduction;
        float _damageReductionPhysical = (float)wandConfig.getDouble("protection_physical", this.damageReductionPhysical);
        this.damageReductionPhysical = safe ? Math.max(_damageReductionPhysical, this.damageReductionPhysical) : _damageReductionPhysical;
        float _damageReductionProjectiles = (float)wandConfig.getDouble("protection_projectiles", this.damageReductionProjectiles);
        this.damageReductionProjectiles = safe ? Math.max(_damageReductionProjectiles, this.damageReductionPhysical) : _damageReductionProjectiles;
        float _damageReductionFalling = (float)wandConfig.getDouble("protection_falling", this.damageReductionFalling);
        this.damageReductionFalling = safe ? Math.max(_damageReductionFalling, this.damageReductionFalling) : _damageReductionFalling;
        float _damageReductionFire = (float)wandConfig.getDouble("protection_fire", this.damageReductionFire);
        this.damageReductionFire = safe ? Math.max(_damageReductionFire, this.damageReductionFire) : _damageReductionFire;
        float _damageReductionExplosions = (float)wandConfig.getDouble("protection_explosions", this.damageReductionExplosions);
        this.damageReductionExplosions = safe ? Math.max(_damageReductionExplosions, this.damageReductionExplosions) : _damageReductionExplosions;
        int _xpRegeneration = wandConfig.getInt("xp_regeneration", this.xpRegeneration);
        this.xpRegeneration = safe ? Math.max(_xpRegeneration, this.xpRegeneration) : _xpRegeneration;
        int _xpMax = wandConfig.getInt("xp_max", this.xpMax);
        this.xpMax = safe ? Math.max(_xpMax, this.xpMax) : _xpMax;
        int _xp = wandConfig.getInt("xp", this.xp);
        this.xp = safe ? Math.max(_xp, this.xp) : _xp;
        int _healthRegeneration = wandConfig.getInt("health_regeneration", this.healthRegeneration);
        this.healthRegeneration = safe ? Math.max(_healthRegeneration, this.healthRegeneration) : _healthRegeneration;
        int _hungerRegeneration = wandConfig.getInt("hunger_regeneration", this.hungerRegeneration);
        this.hungerRegeneration = safe ? Math.max(_hungerRegeneration, this.hungerRegeneration) : _hungerRegeneration;
        int _uses = wandConfig.getInt("uses", this.uses);
        this.uses = safe ? Math.max(_uses, this.uses) : _uses;
        this.effectColor = Integer.parseInt(wandConfig.getString("effect_color", "0"), 16);
        float oldWalkSpeedIncrease = this.speedIncrease;
        this.speedIncrease = (float)wandConfig.getDouble("haste", this.speedIncrease);
        if (this.activePlayer != null && this.speedIncrease != oldWalkSpeedIncrease) {
            Player player = this.activePlayer.getPlayer();
            player.setWalkSpeed(this.defaultWalkSpeed + this.speedIncrease);
            player.setFlySpeed(this.defaultFlySpeed + this.speedIncrease);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public static void reset(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        propertiesFile.delete();
    }

    public static void load(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File oldDefaults = new File(dataFolder, propertiesFileNameDefaults);
        oldDefaults.delete();
        plugin.getLogger().info("Overwriting file wands.defaults.yml");
        plugin.saveResource(propertiesFileNameDefaults, false);
        File propertiesFile = new File(dataFolder, propertiesFileName);
        if (!propertiesFile.exists()) {
            plugin.getLogger().info("Loading default wands from wands.defaults.yml");
            Wand.loadProperties(plugin.getResource(propertiesFileNameDefaults));
        } else {
            plugin.getLogger().info("Loading wands from " + propertiesFile.getName());
            Wand.loadProperties(propertiesFile);
        }
    }

    private static void loadProperties(File propertiesFile) {
        Wand.loadProperties(new Configuration(propertiesFile));
    }

    private static void loadProperties(InputStream properties) {
        Wand.loadProperties(new Configuration(properties));
    }

    private static void loadProperties(Configuration properties) {
        properties.load();
        wandTemplates.clear();
        ConfigurationNode wandList = properties.getNode("wands");
        if (wandList == null) {
            return;
        }
        List<String> wandKeys = wandList.getKeys();
        for (String key : wandKeys) {
            ConfigurationNode wandNode = wandList.getNode(key);
            wandNode.setProperty("key", key);
            wandTemplates.put(key, wandNode);
            if (!key.equals("random")) continue;
            WandLevel.mapLevels(wandNode);
        }
    }

    public static Collection<ConfigurationNode> getWandTemplates() {
        return wandTemplates.values();
    }

    private void updateActiveMaterial() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activePlayer.clearBuildingMaterial();
        } else {
            String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
            if (pieces.length > 0) {
                byte data = 0;
                if (pieces.length > 1) {
                    data = Byte.parseByte(pieces[1]);
                }
                int materialId = Integer.parseInt(pieces[0]);
                Material material = null;
                material = materialId == 0 ? EraseMaterial : (materialId == -1 ? CopyMaterial : Material.getMaterial((int)materialId));
                this.activePlayer.setBuildingMaterial(material, data);
            }
        }
    }

    public void toggleInventory() {
        if (!this.hasInventory) {
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void cycleInventory() {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            this.openInventoryPage = (this.openInventoryPage + 1) % this.inventories.size();
            this.updateInventory();
            if (this.activePlayer != null && this.inventories.size() > 1) {
                this.activePlayer.playSound(Sound.CHEST_OPEN, 0.3f, 1.5f);
                this.activePlayer.getPlayer().updateInventory();
            }
        }
    }

    private void openInventory() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.activePlayer.hasStoredInventory()) {
            return;
        }
        if (this.activePlayer.storeInventory()) {
            this.inventoryIsOpen = true;
            this.activePlayer.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
            this.updateInventory();
            this.activePlayer.getPlayer().updateInventory();
        }
    }

    public void closeInventory() {
        if (!this.isInventoryOpen()) {
            return;
        }
        this.saveInventory();
        this.inventoryIsOpen = false;
        if (this.activePlayer != null) {
            this.activePlayer.playSound(Sound.CHEST_CLOSE, 0.4f, 0.2f);
            this.activePlayer.restoreInventory();
            this.activePlayer.getPlayer().updateInventory();
            ItemStack newWandItem = this.activePlayer.getPlayer().getInventory().getItemInHand();
            if (Wand.isWand(newWandItem)) {
                this.item = newWandItem;
                this.updateName();
            }
        }
        this.saveState();
    }

    public void activate(PlayerSpells playerSpells) {
        if (this.owner.length() == 0) {
            this.takeOwnership(playerSpells.getPlayer());
        }
        this.activePlayer = playerSpells;
        Player player = this.activePlayer.getPlayer();
        if (this.speedIncrease > 0.0f) {
            try {
                player.setWalkSpeed(this.defaultWalkSpeed + this.speedIncrease);
                player.setFlySpeed(this.defaultFlySpeed + this.speedIncrease);
            }
            catch (Exception ex2) {
                try {
                    player.setWalkSpeed(this.defaultWalkSpeed);
                    player.setFlySpeed(this.defaultFlySpeed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.activePlayer.setActiveWand(this);
        if (this.xpRegeneration > 0) {
            this.storedXpLevel = player.getLevel();
            this.storedXpProgress = player.getExp();
            this.storedXp = 0;
            this.updateMana();
        }
        this.updateActiveMaterial();
        this.updateName();
        if (this.effectColor != 0) {
            InventoryUtils.addPotionEffect((LivingEntity)player, this.effectColor);
        }
    }

    protected void updateMana() {
        if (this.activePlayer != null && this.xpMax > 0 && this.xpRegeneration > 0) {
            Player player = this.activePlayer.getPlayer();
            player.setLevel(0);
            player.setExp((float)this.xp / (float)this.xpMax);
        }
    }

    public boolean isInventoryOpen() {
        return this.activePlayer != null && this.inventoryIsOpen;
    }

    public void deactivate() {
        if (this.activePlayer == null) {
            return;
        }
        this.saveState();
        if (this.effectColor > 0) {
            InventoryUtils.removePotionEffect((LivingEntity)this.activePlayer.getPlayer());
        }
        this.activePlayer.deactivateAllSpells();
        if (this.isInventoryOpen()) {
            this.closeInventory();
        }
        this.activePlayer.restoreInventory();
        if (this.xpRegeneration > 0) {
            this.activePlayer.player.setExp(this.storedXpProgress);
            this.activePlayer.player.setLevel(this.storedXpLevel);
            this.activePlayer.player.giveExp(this.storedXp);
            this.storedXp = 0;
            this.storedXpProgress = 0.0f;
            this.storedXpLevel = 0;
        }
        if (this.speedIncrease > 0.0f) {
            try {
                this.activePlayer.getPlayer().setWalkSpeed(this.defaultWalkSpeed);
                this.activePlayer.getPlayer().setFlySpeed(this.defaultFlySpeed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activePlayer.setActiveWand(null);
        this.activePlayer = null;
    }

    public Spell getActiveSpell() {
        if (this.activePlayer == null) {
            return null;
        }
        return this.activePlayer.getSpell(this.activeSpell);
    }

    public boolean cast() {
        Spell spell = this.getActiveSpell();
        if (spell != null && spell.cast()) {
            this.use();
            return true;
        }
        return false;
    }

    protected void use() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.uses > 0) {
            --this.uses;
            if (this.uses <= 0) {
                Player player = this.activePlayer.getPlayer();
                this.activePlayer.playSound(Sound.ITEM_BREAK, 1.0f, 0.8f);
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                player.updateInventory();
                this.deactivate();
            } else {
                this.updateName();
                this.updateLore();
                this.saveState();
            }
        }
    }

    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (this.activePlayer == null) {
            return;
        }
        if (this.xpRegeneration > 0) {
            this.storedXp += event.getAmount();
            event.setAmount(0);
        }
    }

    public void processRegeneration() {
        if (this.activePlayer == null) {
            return;
        }
        Player player = this.activePlayer.getPlayer();
        if (this.xpRegeneration > 0) {
            this.xp = Math.min(this.xpMax, this.xp + this.xpRegeneration);
            this.updateMana();
        }
        double maxHealth = player.getMaxHealth();
        if (this.healthRegeneration > 0 && player.getHealth() < maxHealth) {
            player.setHealth(Math.min(maxHealth, player.getHealth() + (double)this.healthRegeneration));
        }
        double maxFoodLevel = 20.0;
        if (this.hungerRegeneration > 0 && (double)player.getFoodLevel() < maxFoodLevel) {
            player.setExhaustion(0.0f);
            player.setFoodLevel(Math.min(20, player.getFoodLevel() + this.hungerRegeneration));
        }
        if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
            player.setFireTicks(0);
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Wand)) {
            return false;
        }
        Wand otherWand = (Wand)other;
        if (this.id == null || otherWand.id == null) {
            return false;
        }
        return otherWand.id.equals(this.id);
    }

    public Spells getMaster() {
        return this.spells;
    }

    public void cycleSpells() {
        Set<String> spellsSet = this.getSpells();
        String[] spells = (String[])spellsSet.toArray();
        if (spells.length == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.activeSpell = spells[0].split("@")[0];
            return;
        }
        int spellIndex = 0;
        int i = 0;
        while (i < spells.length) {
            if (spells[i].split("@")[0].equals(this.activeSpell)) {
                spellIndex = i;
                break;
            }
            ++i;
        }
        spellIndex = (spellIndex + 1) % spells.length;
        this.setActiveSpell(spells[spellIndex].split("@")[0]);
    }

    public void cycleMaterials() {
        Set<String> materialsSet = this.getMaterialNames();
        String[] materials = (String[])materialsSet.toArray();
        if (materials.length == 0) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activeMaterial = materials[0].split("@")[0];
            return;
        }
        int materialIndex = 0;
        int i = 0;
        while (i < materials.length) {
            if (materials[i].split("@")[0].equals(this.activeMaterial)) {
                materialIndex = i;
                break;
            }
            ++i;
        }
        materialIndex = (materialIndex + 1) % materials.length;
        this.setActiveMaterial(materials[materialIndex].split("@")[0]);
    }

    public boolean hasExperience() {
        return this.xpRegeneration > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void organizeInventory() {
        if (this.activePlayer == null) {
            return;
        }
        this.closeInventory();
        HashSet<String> hotbarSpellNames = new HashSet<String>();
        HashSet<String> hotbarMaterialNames = new HashSet<String>();
        Player player = this.activePlayer.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        int i = 0;
        while (i < 9) {
            ItemStack playerItem = playerInventory.getItem(i);
            if (playerItem != null && playerItem.getType() != Material.AIR) {
                String spellName = Wand.getSpell(playerItem);
                if (spellName != null) {
                    hotbarSpellNames.add(spellName);
                } else {
                    String string = this.getMaterialKey(playerItem);
                    if (string != null) {
                        hotbarMaterialNames.add(string);
                    }
                }
            }
            ++i;
        }
        HashMap<String, TreeSet<String>> groupedSpells = new HashMap<String, TreeSet<String>>();
        Set<String> spells = this.getSpells();
        for (String spellName : spells) {
            TreeSet<String> spellList;
            Spell spell = this.activePlayer.getSpell(spellName);
            if (spell == null || hotbarSpellNames.contains(spellName)) continue;
            String category = spell.getCategory();
            if (category == null || category.length() == 0) {
                category = "default";
            }
            if ((spellList = (TreeSet<String>)groupedSpells.get(category)) == null) {
                spellList = new TreeSet<String>();
                groupedSpells.put(category, spellList);
            }
            spellList.add(spellName);
        }
        Set<String> materials = this.getMaterialNames();
        for (String string : hotbarMaterialNames) {
            materials.remove(string);
        }
        this.inventories.clear();
        int n = 0;
        Inventory currentInventory = this.getInventory(n);
        for (Collection spellGroup : groupedSpells.values()) {
            void var8_14;
            for (String spellName : spellGroup) {
                HashMap result = currentInventory.addItem(new ItemStack[]{this.createSpellItem(spellName)});
                if (result.size() <= 0) continue;
                currentInventory = this.getInventory((int)(++var8_14));
            }
            currentInventory = this.getInventory((int)(++var8_14));
        }
        for (String materialName : materials) {
            void var8_15;
            HashMap result = currentInventory.addItem(new ItemStack[]{this.createMaterialItem(materialName)});
            if (result.size() <= 0) continue;
            currentInventory = this.getInventory((int)(++var8_15));
        }
        this.saveState();
        this.openInventory();
    }

    public String getId() {
        return this.id;
    }
}

