/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;

public class GillsSpell
extends Spell {
    private int gillDuration = 60;
    private int healFrequency = 1000;
    private int healAmount = 4;
    private HashMap<String, PlayerGills> gillPlayers = new HashMap();

    public SpellResult onCast(ConfigurationNode parameters) {
        PlayerGills hasGills = this.gillPlayers.get(this.player.getName());
        if (hasGills != null) {
            this.castMessage("Your gills recede");
            this.gillPlayers.remove(this.player.getName());
        } else {
            this.castMessage("You grow gills!");
            this.gillPlayers.put(this.player.getName(), new PlayerGills(this.gillDuration * 1000));
        }
        this.checkListener();
        return SpellResult.SUCCESS;
    }

    protected void checkListener() {
        if (this.gillPlayers.size() == 0) {
            this.spells.unregisterEvent(SpellEventType.PLAYER_MOVE, this);
        } else {
            this.spells.registerEvent(SpellEventType.PLAYER_MOVE, this);
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        PlayerGills gills = this.gillPlayers.get(player.getName());
        if (gills != null) {
            gills.move();
            if (gills.isTimeToRecede()) {
                this.sendMessage("Your gills recede!");
                this.gillPlayers.remove(player.getName());
                this.checkListener();
            } else if (gills.isTimeToHeal(this.healFrequency)) {
                gills.heal();
                if (this.isUnderwater()) {
                    double health = player.getHealth();
                    if (health < 20.0) {
                        health += (double)this.healAmount;
                    }
                    player.setHealth(health);
                }
            }
        }
    }

    public void onLoadTemplate(ConfigurationNode properties) {
        this.disableTargeting();
        this.gillDuration = properties.getInteger("duration", this.gillDuration);
        this.healFrequency = properties.getInteger("heal_frequency", this.healFrequency);
        this.healAmount = properties.getInteger("heal_amount", this.healAmount);
    }

    public class PlayerGills {
        public long lastHealTick;
        public long lastMoveTick;
        public int timeRemaining;

        public PlayerGills(int duration) {
            this.lastHealTick = this.lastMoveTick = System.currentTimeMillis();
            this.timeRemaining = duration;
        }

        public void move() {
            long thisMoveTick = System.currentTimeMillis();
            int timeDelta = (int)(thisMoveTick - this.lastMoveTick);
            this.lastMoveTick = thisMoveTick;
            this.timeRemaining -= timeDelta;
        }

        public void heal() {
            this.lastHealTick = System.currentTimeMillis();
        }

        public boolean isTimeToHeal(int frequency) {
            int healDelta = (int)(this.lastMoveTick - this.lastHealTick);
            return healDelta > frequency;
        }

        public boolean isTimeToRecede() {
            return this.timeRemaining < 0;
        }
    }
}

