/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DisintegrateSpell
extends Spell {
    private int playerDamage = 1;
    private int entityDamage = 100;
    private static final int maxEffectRange = 16;
    private static final int effectSpeed = 1;
    private static final int effectPeriod = 2;
    private static final float particleSpeed = 1.0f;
    private static final int particleCount = 6;

    public SpellResult onCast(ConfigurationNode parameters) {
        Entity targetEntity;
        int effectRange = Math.min(this.getMaxRange(), 16);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effectTrail = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        effectTrail.setParticleType(ParticleType.LAVA_DRIPPING);
        effectTrail.setParticleCount(6);
        effectTrail.setEffectSpeed(1.0f);
        effectTrail.setParticleOffset(0.2f, 0.2f, 0.2f);
        effectTrail.setSpeed(1.0f);
        effectTrail.setPeriod(2);
        effectTrail.start();
        Target target = this.getTarget();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (target.isEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (li instanceof Player) {
                li.damage((double)(this.playerSpells.getPowerMultiplier() * (float)this.playerDamage), (Entity)this.player);
            } else {
                li.damage((double)(this.playerSpells.getPowerMultiplier() * (float)this.entityDamage), (Entity)this.player);
            }
            this.castMessage("ZOT!");
            return SpellResult.SUCCESS;
        }
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        BlockList disintigrated = new BlockList();
        disintigrated.add(targetBlock);
        if (!this.hasBuildPermission(targetBlock)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.isUnderwater()) {
            targetBlock.setType(Material.STATIONARY_WATER);
        } else {
            targetBlock.setType(Material.AIR);
        }
        this.spells.addToUndoQueue(this.player, disintigrated);
        this.castMessage("ZAP!");
        return SpellResult.SUCCESS;
    }

    public void onLoadTemplate(ConfigurationNode properties) {
        this.playerDamage = properties.getInteger("player_damage", this.playerDamage);
        this.entityDamage = properties.getInteger("entity_damage", this.entityDamage);
    }
}

