/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.SimpleBlockAction;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FireSpell
extends Spell {
    private static final int maxEffectRange = 16;
    private static final int effectSpeed = 1;
    private static final float particleSpeed = 0.2f;
    private static final int effectPeriod = 2;
    private static final int particleCount = 1;
    private int defaultRadius = 4;
    private int verticalSearchDistance = 8;

    public SpellResult onCast(ConfigurationNode parameters) {
        int effectRange = Math.min(this.getMaxRange(), 16);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effectTrail = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        effectTrail.setParticleType(ParticleType.FLAME);
        effectTrail.setParticleCount(1);
        effectTrail.setEffectSpeed(0.2f);
        effectTrail.setParticleOffset(0.2f, 0.2f, 0.2f);
        effectTrail.setSpeed(1.0f);
        effectTrail.setPeriod(2);
        effectTrail.start();
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        radius = (int)(this.playerSpells.getPowerMultiplier() * (float)radius);
        FireAction action = new FireAction();
        if (radius <= 1) {
            action.perform(target);
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.spells.addToUndoQueue(this.player, action.getBlocks());
        this.castMessage("Burned " + action.getBlocks().size() + " blocks");
        return SpellResult.SUCCESS;
    }

    /*
     * Unable to fully structure code
     */
    public void burnBlock(int dx, int dy, int dz, Block centerPoint, int radius, BlockList burnedBlocks) {
        block5: {
            x = centerPoint.getX() + dx - radius;
            y = centerPoint.getY() + dy - radius;
            z = centerPoint.getZ() + dz - radius;
            block = this.player.getWorld().getBlockAt(x, y, z);
            depth = 0;
            if (block.getType() != Material.AIR) ** GOTO lbl14
            while (depth < this.verticalSearchDistance && block.getType() == Material.AIR) {
                ++depth;
                block = block.getRelative(BlockFace.DOWN);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ++depth;
                block = block.getRelative(BlockFace.UP);
lbl14:
                // 2 sources

                ** while (depth < this.verticalSearchDistance && block.getType() != Material.AIR)
            }
lbl15:
            // 1 sources

            block = block.getRelative(BlockFace.DOWN);
        }
        if (block.getType() == Material.AIR || block.getType() == Material.FIRE) {
            return;
        }
        material = Material.FIRE;
        if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER || block.getType() == Material.ICE || block.getType() == Material.SNOW) {
            material = Material.AIR;
        } else {
            block = block.getRelative(BlockFace.UP);
        }
        burnedBlocks.add(block);
        block.setType(material);
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public void onLoadTemplate(ConfigurationNode properties) {
        this.defaultRadius = properties.getInteger("radius", this.defaultRadius);
        this.verticalSearchDistance = properties.getInteger("vertical_search_distance", this.verticalSearchDistance);
    }

    public class FireAction
    extends SimpleBlockAction {
        public SpellResult perform(Block block) {
            if (block.getType() == Material.AIR || block.getType() == Material.FIRE) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.FIRE;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER || block.getType() == Material.ICE || block.getType() == Material.SNOW) {
                material = Material.AIR;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            block.setType(material);
            return SpellResult.SUCCESS;
        }
    }
}

