/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BoomSpell
extends Spell {
    protected int defaultSize = 1;
    static final int effectSpeed = 6;
    static final int effectPeriod = 1;
    static final int maxEffectRange = 32;

    public SpellResult createExplosionAt(Location target, float size, boolean incendiary, boolean breakBlocks) {
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Location l = target.getBlock().getLocation();
        this.player.getWorld().createExplosion(l.getX(), l.getY(), l.getZ(), size, incendiary, breakBlocks);
        return SpellResult.SUCCESS;
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        boolean useFire = parameters.getBoolean("fire", false);
        boolean breakBlocks = parameters.getBoolean("break_blocks", true);
        boolean showEffect = parameters.getBoolean("show_effect", true);
        String targetType = parameters.getString("target", "");
        size = (int)(this.playerSpells.getPowerMultiplier() * (float)size);
        if (targetType.equals("here")) {
            this.player.damage(this.player.getMaxHealth() * 10.0);
            return this.createExplosionAt(this.player.getLocation(), size, useFire, breakBlocks);
        }
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (showEffect) {
            int effectRange = Math.min(this.getMaxRange(), 5);
            Location effectLocation = this.player.getEyeLocation();
            Vector effectDirection = effectLocation.getDirection();
            EffectTrail effect = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
            effect.setPeriod(1);
            effect.setSpeed(6.0f);
            FireworkEffect fireworkEffect = FireworkEffect.builder().flicker(true).withColor(Color.RED).withFade(Color.ORANGE).with(FireworkEffect.Type.BURST).build();
            effect.setFireworkEffect(fireworkEffect, 1);
            effect.start();
        }
        return this.createExplosionAt(target.getLocation(), size, useFire, breakBlocks);
    }
}

