/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.WandChestPopulator;
import com.elmakers.mine.bukkit.utilities.NMSUtils;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class WandChestRunnable
extends BukkitRunnable {
    World world;
    int dx = 1;
    int dz = 0;
    int segmentLength = 1;
    int x;
    int z;
    int segmentPassed = 0;
    int maxy;
    WandChestPopulator populator;
    Random random;
    Logger logger;

    public WandChestRunnable(Spells spells, World world, int maxy) {
        this.world = world;
        this.maxy = maxy;
        this.random = new Random();
        this.logger = spells.getPlugin().getLogger();
        this.populator = spells.getWandChestPopulator();
    }

    public void run() {
        Chunk chunk = this.world.getChunkAt(this.x, this.z);
        if (!NMSUtils.isDone(chunk) || !chunk.isLoaded()) {
            if (!NMSUtils.isDone(chunk) || !chunk.load(false)) {
                this.logger.info("Done populating chests, found ungenerated chunk");
                this.cancel();
            }
        } else {
            this.logger.info("Looking for chests in chunk at " + this.x + "," + this.z);
            this.populator.populate(this.world, this.random, chunk);
            this.x += this.dx;
            this.z += this.dz;
            ++this.segmentPassed;
            if (this.segmentPassed == this.segmentLength) {
                this.segmentPassed = 0;
                int odx = this.dx;
                this.dx = -this.dz;
                this.dz = odx;
                if (this.dz == 0) {
                    ++this.segmentLength;
                }
            }
        }
    }
}

