/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target
implements Comparable<Target> {
    protected int maxDistance = 512;
    protected double maxAngle = 0.3;
    private Entity entity;
    private Player player;
    private Block block;
    private double distance = 100000.0;
    private double angle = 10000.0;
    private int score = 0;

    public Target(Player player, Block block) {
        this.player = player;
        this.block = block;
        this.calculateScore();
    }

    public Target(Player player, Entity entity, int range) {
        this.maxDistance = range;
        this.player = player;
        this.entity = entity;
        this.calculateScore();
    }

    public int getScore() {
        return this.score;
    }

    protected void calculateScore() {
        Vector playerFacing = this.player.getLocation().getDirection();
        Vector playerLoc = new Vector(this.player.getLocation().getBlockX(), this.player.getLocation().getBlockY(), this.player.getLocation().getBlockZ());
        Location targetLocation = this.getLocation();
        if (targetLocation == null) {
            return;
        }
        Vector targetLoc = new Vector(targetLocation.getBlockX(), targetLocation.getBlockY(), targetLocation.getBlockZ());
        Vector targetDirection = new Vector(targetLoc.getBlockX() - playerLoc.getBlockX(), targetLoc.getBlockY() - playerLoc.getBlockY(), targetLoc.getBlockZ() - playerLoc.getBlockZ());
        this.angle = targetDirection.angle(playerFacing);
        this.distance = targetDirection.length();
        this.score = 0;
        if (this.angle > this.maxAngle) {
            return;
        }
        if (this.distance > (double)this.maxDistance) {
            return;
        }
        this.score = (int)((double)this.maxDistance - this.distance + (3.0 - this.angle) * 4.0);
        this.score = this.entity instanceof Player ? (this.score += 3) : (this.entity instanceof LivingEntity ? (this.score += 5) : ++this.score);
    }

    @Override
    public int compareTo(Target other) {
        return other.score - this.score;
    }

    public boolean isEntity() {
        return this.entity != null;
    }

    public boolean isBlock() {
        return this.block != null;
    }

    public boolean hasTarget() {
        return this.isEntity() || this.isBlock();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Block getBlock() {
        if (this.block == null && this.entity != null) {
            return this.entity.getLocation().getBlock();
        }
        return this.block;
    }

    public double getDistance() {
        return this.distance;
    }

    public Location getLocation() {
        if (this.entity != null) {
            return this.entity.getLocation();
        }
        if (this.block != null) {
            return this.block.getLocation();
        }
        return null;
    }
}

