/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.dao.BlockData;
import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.block.Block;

public class UndoQueue {
    private final LinkedList<BlockList> blockQueue = new LinkedList();
    private int maxSize = 0;

    public void add(BlockList blocks) {
        if (this.maxSize > 0 && this.blockQueue.size() > this.maxSize) {
            this.blockQueue.removeFirst();
        }
        this.blockQueue.add(blocks);
    }

    public BlockList getLast() {
        if (this.blockQueue.isEmpty()) {
            return null;
        }
        return this.blockQueue.getLast();
    }

    public BlockList getLast(Block target) {
        if (this.blockQueue.size() == 0) {
            return null;
        }
        for (BlockList blocks : this.blockQueue) {
            if (!blocks.contains(target)) continue;
            return blocks;
        }
        return null;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public boolean undo(Spells spells) {
        if (this.blockQueue.size() == 0) {
            return false;
        }
        BlockList blocks = this.blockQueue.removeLast();
        blocks.undo(spells);
        return true;
    }

    public boolean undo(Spells spells, Block target) {
        BlockList lastActionOnTarget = this.getLast(target);
        if (lastActionOnTarget == null) {
            return false;
        }
        this.blockQueue.remove(lastActionOnTarget);
        lastActionOnTarget.undo(spells);
        return true;
    }

    public void load(ConfigurationNode node) {
        if (node == null) {
            return;
        }
        List<String> keys = node.getKeys();
        for (String key : keys) {
            BlockList list = new BlockList();
            ConfigurationNode listNode = node.getNode(key);
            List<String> listKeys = listNode.getKeys();
            for (String listKey : listKeys) {
                list.add(listNode.getBlockData(listKey));
            }
            this.blockQueue.add(list);
        }
    }

    public void save(ConfigurationNode node) {
        int index = 0;
        for (BlockList list : this.blockQueue) {
            ConfigurationNode listNode = node.createChild(Integer.valueOf(index).toString());
            ++index;
            int blockIndex = 0;
            for (BlockData data : list.getBlockList()) {
                listNode.setProperty(Integer.valueOf(blockIndex).toString(), data);
                ++blockIndex;
            }
        }
    }
}

