/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class FlingSpell
extends Spell {
    private final long safetyLength = 20000L;
    private long lastFling = 0L;
    protected int defaultMaxSpeedAtElevation = 64;
    protected double defaultMinMagnitude = 1.5;
    protected double defaultMaxMagnitude = 6.0;

    public SpellResult onCast(ConfigurationNode parameters) {
        int height = 0;
        Block playerBlock = this.player.getLocation().getBlock();
        int maxSpeedAtElevation = parameters.getInt("cruising_altitude", this.defaultMaxSpeedAtElevation);
        double minMagnitude = parameters.getDouble("min_speed", this.defaultMinMagnitude);
        double maxMagnitude = parameters.getDouble("max_speed", this.defaultMaxMagnitude);
        while (height < maxSpeedAtElevation && playerBlock.getType() == Material.AIR) {
            playerBlock = playerBlock.getRelative(BlockFace.DOWN);
            ++height;
        }
        double heightModifier = maxSpeedAtElevation > 0 ? (double)height / (double)maxSpeedAtElevation : 1.0;
        double magnitude = minMagnitude + (maxMagnitude - minMagnitude) * heightModifier;
        Vector velocity = this.getAimVector();
        if (this.player.getLocation().getBlockY() >= 256) {
            velocity.setY(0);
        }
        velocity.multiply(magnitude);
        this.player.setVelocity(velocity);
        this.castMessage("Whee!");
        this.spells.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.lastFling = System.currentTimeMillis();
        return SpellResult.SUCCESS;
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.spells.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.lastFling == 0L) {
            return;
        }
        if (this.lastFling + 20000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.lastFling = 0L;
        }
    }

    public void onLoadTemplate(ConfigurationNode node) {
        this.disableTargeting();
    }
}

