/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.dao;

import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BlockVector;

public class BlockData {
    public static final BlockFace[] FACES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.UP, BlockFace.DOWN};
    public static final BlockFace[] SIDES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST};
    protected Block block;
    public BlockVector location;
    public String world;
    public Material material;
    public byte materialData;
    protected static Server server;

    public static void setServer(Server server) {
        BlockData.server = server;
    }

    public static long getBlockId(Block block) {
        return block.getWorld().getName().hashCode() << 28 ^ Integer.valueOf(block.getX()).hashCode() << 13 ^ Integer.valueOf(block.getY()).hashCode() << 7 ^ Integer.valueOf(block.getZ()).hashCode();
    }

    public static long getBlockId(BlockData blockData) {
        return BlockData.getBlockId(blockData.getBlock());
    }

    public static BlockFace getReverseFace(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.EAST;
            }
            case SOUTH: {
                return BlockFace.NORTH;
            }
            case EAST: {
                return BlockFace.WEST;
            }
            case UP: {
                return BlockFace.DOWN;
            }
            case DOWN: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    public BlockData() {
    }

    public BlockData(Block block) {
        this.block = block;
        this.location = new BlockVector(block.getX(), block.getY(), block.getZ());
        this.world = block.getWorld().getName();
        this.material = block.getType();
        this.materialData = block.getData();
    }

    public BlockData(BlockData copy) {
        this.location = copy.location;
        this.world = copy.world;
        this.material = copy.material;
        this.materialData = copy.materialData;
        this.block = copy.block;
    }

    public BlockData(Location location, Material material, byte data) {
        this.location = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.world = location.getWorld().getName();
        this.material = material;
        this.materialData = data;
    }

    protected boolean checkBlock() {
        if (this.block == null) {
            this.block = this.getBlock();
        }
        return this.block != null;
    }

    public Block getBlock() {
        Location blockLocation;
        if (this.block == null && this.location != null && server != null && (blockLocation = new Location(server.getWorld(this.world), (double)this.location.getBlockX(), (double)this.location.getBlockY(), (double)this.location.getBlockZ())) != null) {
            this.block = blockLocation.getBlock();
        }
        return this.block;
    }

    public BlockVector getPosition() {
        return this.location;
    }

    public Material getMaterial() {
        return this.material;
    }

    public byte getMaterialData() {
        return this.materialData;
    }

    public void setPosition(BlockVector location) {
        this.location = location;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setMaterialData(byte materialData) {
        this.materialData = materialData;
    }

    public boolean undo() {
        if (!this.checkBlock()) {
            return true;
        }
        Chunk chunk = this.block.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load();
            return false;
        }
        if (this.block.getType() != this.material || this.block.getData() != this.materialData) {
            this.block.setType(this.material);
            this.block.setData(this.materialData);
        }
        return true;
    }
}

