/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;

public class TreeSpell
extends Spell {
    private TreeType defaultTreeType = null;
    private boolean requireSapling = false;

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean result;
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (this.requireSapling && target.getType() != Material.SAPLING) {
            this.castMessage("Plant a sapling first");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Location treeLoc = new Location(this.player.getWorld(), (double)target.getX(), (double)(target.getY() + 1), (double)target.getZ(), 0.0f, 0.0f);
        TreeType treeType = this.defaultTreeType;
        String typeString = parameters.getString("type", "");
        treeType = TreeSpell.parseTreeString(typeString, this.defaultTreeType);
        if (treeType == null) {
            treeType = TreeType.values()[(int)(Math.random() * (double)TreeType.values().length)];
        }
        if (result = this.player.getWorld().generateTree(treeLoc, treeType)) {
            this.castMessage("You grow a " + this.getTreeName(treeType) + " tree");
        } else {
            this.castMessage("Your tree didn't grow");
        }
        return result ? SpellResult.SUCCESS : SpellResult.FAILURE;
    }

    public String getTreeName(TreeType treeType) {
        return treeType.name().toLowerCase();
    }

    public static TreeType parseTreeString(String s, TreeType defaultTreeType) {
        if (s.equalsIgnoreCase("big")) {
            return TreeType.BIG_TREE;
        }
        if (s.equalsIgnoreCase("tall")) {
            return TreeType.TALL_REDWOOD;
        }
        TreeType tree = defaultTreeType;
        TreeType[] treeTypeArray = TreeType.values();
        int n = treeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeType t = treeTypeArray[n2];
            if (t.name().equalsIgnoreCase(s)) {
                tree = t;
            }
            ++n2;
        }
        return tree;
    }

    public void onLoadTemplate(ConfigurationNode properties) {
        this.requireSapling = properties.getBoolean("require_sapling", this.requireSapling);
    }
}

