/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.EffectPlayer;
import com.elmakers.mine.bukkit.utilities.EffectRing;
import com.elmakers.mine.bukkit.utilities.EffectTrail;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PushSpell
extends Spell {
    private int itemMagnitude = 1;
    private int entityMagnitude = 3;
    private int maxAllDistance = 20;
    private boolean allowAll = true;
    private static final int effectSpeed = 2;
    private static final int effectPeriod = 2;
    private static final int ringEffectAmount = 8;
    private static final int maxEffectRange = 16;
    private static final int maxRingEffectRange = 6;

    public void forceAll(double mutliplier, boolean pull) {
        float maxDistance = (float)this.maxAllDistance * this.playerSpells.getPowerMultiplier();
        float maxDistanceSquared = maxDistance * maxDistance;
        int effectRange = Math.min(6, 8);
        Location effectLocation = this.player.getLocation();
        EffectRing effectRing = new EffectRing((Plugin)this.spells.getPlugin(), effectLocation, effectRange, 8);
        if (pull) {
            effectRing.setInvert(true);
        }
        this.startEffect(effectRing, effectRange);
        List entities = this.player.getWorld().getEntities();
        for (Entity target : entities) {
            Location targetLocation;
            Location playerLocation;
            if (target == this.player || (playerLocation = this.player.getLocation()).distanceSquared(targetLocation = target.getLocation()) > (double)maxDistanceSquared) continue;
            Location to = pull ? targetLocation : playerLocation;
            Location from = pull ? playerLocation : targetLocation;
            this.forceEntity(target, mutliplier, from, to);
        }
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean push = false;
        boolean pull = false;
        String typeString = parameters.getString("type", "");
        push = typeString.equals("push");
        pull = typeString.equals("pull");
        double multiplier = parameters.getDouble("size", 1.0);
        multiplier *= (double)this.playerSpells.getPowerMultiplier();
        int count = parameters.getInt("count", 0);
        this.targetEntity(Entity.class);
        List<Target> targets = this.getAllTargetEntities();
        if (this.allowAll && (this.getYRotation() < -80.0 || this.getYRotation() > 80.0)) {
            if (push) {
                this.castMessage("Get away!");
            } else {
                this.castMessage("Gimme!");
            }
            this.forceAll(multiplier, pull);
            return SpellResult.SUCCESS;
        }
        int effectRange = Math.min(this.getMaxRange(), 8);
        Location effectLocation = this.player.getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        if (pull) {
            effectDirection.normalize();
            effectDirection.multiply(2 * effectRange);
            effectLocation.add(effectDirection);
            effectDirection.multiply(-1);
        }
        EffectTrail effectTrail = new EffectTrail((Plugin)this.spells.getPlugin(), effectLocation, effectDirection, effectRange);
        this.startEffect(effectTrail, effectRange);
        if (targets.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        int pushed = 0;
        for (Target target : targets) {
            Entity targetEntity = target.getEntity();
            Location to = pull ? target.getLocation() : this.player.getLocation();
            Location from = pull ? this.player.getLocation() : target.getLocation();
            this.forceEntity(targetEntity, multiplier, from, to);
            if (count > 0 && ++pushed >= count) break;
        }
        if (pull) {
            this.castMessage("Yoink!");
        } else {
            this.castMessage("Shove!");
        }
        return SpellResult.SUCCESS;
    }

    protected void forceEntity(Entity target, double multiplier, Location from, Location to) {
        Vector fromVector;
        int magnitude = target instanceof LivingEntity ? this.entityMagnitude : this.itemMagnitude;
        magnitude = (int)((double)magnitude * multiplier);
        Vector toVector = new Vector(to.getBlockX(), to.getBlockY(), to.getBlockZ());
        Vector forceVector = fromVector = new Vector(from.getBlockX(), from.getBlockY(), from.getBlockZ());
        forceVector.subtract(toVector);
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }

    public void onLoadTemplate(ConfigurationNode properties) {
        this.itemMagnitude = properties.getInt("item_force", this.itemMagnitude);
        this.entityMagnitude = properties.getInt("entity_force", this.entityMagnitude);
        this.allowAll = properties.getBoolean("allow_area", this.allowAll);
        this.maxAllDistance = properties.getInt("area_range", this.maxAllDistance);
    }

    protected void startEffect(EffectPlayer effect, int effectRange) {
        effect.setParticleType(ParticleType.SPELL);
        effect.setParticleCount(3);
        effect.setEffectSpeed(2.0f);
        effect.setParticleOffset(0.2f, 0.2f, 0.2f);
        effect.setSpeed(2.0f);
        effect.setPeriod(2);
        effect.start();
    }
}

