/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class ForceSpell
extends Spell {
    int magnitude = 3;
    LivingEntity targetEntity = null;
    int effectColor = 0;

    public SpellResult onCast(ConfigurationNode parameters) {
        if (this.targetEntity != null && this.targetEntity instanceof LivingEntity) {
            if (!this.targetEntity.isValid() || this.targetEntity.isDead()) {
                this.releaseTarget();
            }
            if (this.targetEntity != null && this.player.getLocation().distanceSquared(this.targetEntity.getLocation()) > (double)this.getMaxRangeSquared()) {
                this.releaseTarget();
            }
        }
        if (this.targetEntity == null) {
            this.targetEntity(LivingEntity.class);
            Target target = this.getTarget();
            if (!(target != null && target.hasTarget() && target.isEntity() && target.getEntity() instanceof LivingEntity)) {
                this.targetEntity = null;
                return SpellResult.NO_TARGET;
            }
            this.targetEntity = (LivingEntity)target.getEntity();
            if (this.effectColor != 0) {
                InventoryUtils.addPotionEffect(this.targetEntity, this.effectColor);
            }
            return SpellResult.COST_FREE;
        }
        double multiplier = parameters.getDouble("size", 1.0);
        this.forceEntity((Entity)this.targetEntity, multiplier);
        return SpellResult.SUCCESS;
    }

    protected void forceEntity(Entity target, double multiplier) {
        this.magnitude = (int)((double)this.magnitude * multiplier);
        Vector forceVector = this.getAimVector();
        forceVector.normalize();
        forceVector.multiply(this.magnitude);
        target.setVelocity(forceVector);
    }

    protected void releaseTarget() {
        if (this.targetEntity != null && this.effectColor != 0) {
            InventoryUtils.addPotionEffect(this.targetEntity, 0);
        }
        this.targetEntity = null;
    }

    public boolean onCancel() {
        if (this.targetEntity != null) {
            if (this.targetEntity instanceof LivingEntity && !this.targetEntity.isDead() && this.player.getLocation().distanceSquared(this.targetEntity.getLocation()) > (double)this.getMaxRangeSquared()) {
                this.castMessage("Released target");
            }
            this.releaseTarget();
            return true;
        }
        return false;
    }

    public void onLoadTemplate(ConfigurationNode properties) {
        this.magnitude = properties.getInt("entity_force", this.magnitude);
        this.effectColor = Integer.parseInt(properties.getString("effect_color", "FF0000"), 16);
    }
}

