/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.URLMap;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CameraSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        String url;
        ItemStack newMapItem = null;
        if (parameters.containsKey("id")) {
            newMapItem = new ItemStack(Material.MAP, 1, (short)parameters.getInt("id", 0));
        }
        if (newMapItem == null && (url = parameters.getString("url")) != null) {
            int x = parameters.getInt("x", 0);
            int y = parameters.getInt("y", 0);
            int width = parameters.getInt("width", 0);
            int height = parameters.getInt("height", 0);
            newMapItem = URLMap.getURLItem(url, x, y, width, height, "Photo");
        }
        if (newMapItem == null) {
            this.targetEntity(Player.class);
            Target target = this.getTarget();
            String playerName = parameters.getString("name");
            if (playerName == null) {
                Player targetPlayer = this.player;
                if (target != null && target.isEntity() && target.getEntity() instanceof Player) {
                    this.castMessage("CLICK!");
                    targetPlayer = (Player)target.getEntity();
                } else {
                    this.castMessage("Selfie!");
                }
                playerName = targetPlayer.getName();
            }
            if (parameters.containsKey("reload")) {
                URLMap.forceReloadPlayerPortrait(playerName);
            }
            newMapItem = URLMap.getPlayerPortrait(playerName);
        }
        if (newMapItem == null) {
            this.sendMessage("Failed to load photo");
            return SpellResult.FAILURE;
        }
        this.player.getWorld().dropItemNaturally(this.player.getLocation(), newMapItem);
        this.player.getWorld().playEffect(this.player.getEyeLocation(), Effect.SMOKE, 0);
        return SpellResult.SUCCESS;
    }
}

