/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.dao.BoundingBox;
import com.elmakers.mine.bukkit.dao.MaterialList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.BlockVector;

public class PortalSpell
extends Spell {
    private int defaultSearchDistance = 255;
    public static MaterialList destructible = null;
    public static int teleportCooldown = 500;
    PlayerPortal a;
    PlayerPortal b;
    BlockVector lastLocation;
    boolean portalling = false;
    long lastTeleport = 0L;
    protected static List<PlayerPortal> allPortals = new ArrayList<PlayerPortal>();

    public void create(Location fromLocation, Location targetLocation) {
        double dist_b;
        if (this.a == null) {
            this.a = new PlayerPortal(targetLocation);
            this.relink();
            return;
        }
        if (this.b == null) {
            this.b = new PlayerPortal(targetLocation);
            this.relink();
            return;
        }
        double dist_a = this.a.getLocation().distanceSquared(fromLocation);
        if (dist_a < (dist_b = this.b.getLocation().distanceSquared(fromLocation))) {
            this.b.remove();
            this.b = new PlayerPortal(targetLocation);
        } else {
            this.a.remove();
            this.a = new PlayerPortal(targetLocation);
        }
        this.relink();
    }

    public void relink() {
        if (this.a != null) {
            this.a.link(this.b);
        }
        if (this.b != null) {
            this.b.link(this.a);
        }
    }

    public boolean hasPortals() {
        return this.a != null || this.b != null;
    }

    public BlockVector getLastLocation() {
        return this.lastLocation;
    }

    public void setLastLocation(BlockVector location) {
        this.lastLocation = location;
    }

    public void setPortalling(boolean p) {
        this.portalling = p;
    }

    public void startTeleporting() {
        this.portalling = true;
        this.lastTeleport = System.currentTimeMillis();
    }

    public boolean readyForTeleport() {
        return !this.portalling && (this.lastTeleport == 0L || this.lastTeleport + (long)teleportCooldown < System.currentTimeMillis());
    }

    public boolean isPortalling() {
        return this.portalling;
    }

    public PlayerPortal getPortal(Location target) {
        if (this.a != null && this.a.contains(target)) {
            return this.a;
        }
        if (this.b != null && this.b.contains(target)) {
            return this.b;
        }
        return null;
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        this.targetThrough(Material.GLASS);
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.defaultSearchDistance > 0 && this.player.getLocation().distanceSquared(target.getLocation()) > (double)(this.defaultSearchDistance * this.defaultSearchDistance)) {
            this.castMessage("Can't create a portal that far away");
            return SpellResult.NO_TARGET;
        }
        Material blockType = target.getType();
        Block portalBase = target.getRelative(BlockFace.UP);
        blockType = portalBase.getType();
        if (blockType != Material.AIR) {
            portalBase = this.getFaceBlock();
        }
        if ((blockType = portalBase.getType()) != Material.AIR && blockType != Material.SNOW) {
            this.castMessage("Can't create a portal there");
            return SpellResult.NO_TARGET;
        }
        this.spells.disablePhysics(10000);
        this.create(this.player.getLocation(), portalBase.getLocation());
        this.checkListener();
        return SpellResult.SUCCESS;
    }

    public void onLoad(ConfigurationNode properties) {
        if (destructible == null) {
            destructible = new MaterialList((Collection<Material>)this.spells.getDestructibleMaterials());
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        Location playerLocation = this.player.getLocation();
        BlockVector lastLoc = this.getLastLocation();
        BlockVector currentLoc = new BlockVector(playerLocation.getBlockX(), playerLocation.getBlockY(), playerLocation.getBlockZ());
        if (lastLoc != null && currentLoc.getBlockX() == lastLoc.getBlockX() && currentLoc.getBlockY() == lastLoc.getBlockY() && currentLoc.getBlockZ() == lastLoc.getBlockZ()) {
            return;
        }
        this.setLastLocation(currentLoc);
        playerLocation.setY(playerLocation.getY() + 2.0);
        Block locationBlock = playerLocation.getBlock();
        if (locationBlock.getType() == Material.PORTAL) {
            if (!this.isPortalling()) {
                PlayerPortal portal;
                if (this.readyForTeleport() && (portal = this.findPortal(playerLocation)) != null) {
                    portal.teleport(this.player, (Plugin)this.spells.getPlugin(), this);
                }
                this.setPortalling(true);
            }
        } else {
            this.setPortalling(false);
        }
    }

    protected PlayerPortal findPortal(Location targetLocation) {
        for (PlayerPortal portal : allPortals) {
            if (!portal.contains(targetLocation)) continue;
            return portal;
        }
        return null;
    }

    protected void checkListener() {
        if (allPortals.size() == 0) {
            this.spells.unregisterEvent(SpellEventType.PLAYER_MOVE, this);
        } else {
            this.spells.registerEvent(SpellEventType.PLAYER_MOVE, this);
        }
    }

    public class PlayerPortal {
        protected Location base;
        protected BlockList portalBlocks;
        protected PlayerPortal target;

        public PlayerPortal(Location targetLocation) {
            this.base = targetLocation;
            this.portalBlocks = new BlockList();
            this.buildPortalBlocks(this.base, BlockFace.NORTH, this.portalBlocks);
            allPortals.add(this);
        }

        protected void buildPortalBlocks(Location centerBlock, BlockFace facing, BlockList blockList) {
            BoundingBox container = new BoundingBox(centerBlock.getBlockX(), centerBlock.getBlockY(), centerBlock.getBlockZ(), centerBlock.getBlockX() + 2, centerBlock.getBlockY() + 3, centerBlock.getBlockZ() + 1);
            container.fill(centerBlock.getWorld(), Material.PORTAL, destructible, blockList);
        }

        public void remove() {
            this.portalBlocks.undo(PortalSpell.this.spells);
            this.portalBlocks = null;
            allPortals.remove(this);
        }

        public Location getLocation() {
            return this.base;
        }

        public boolean contains(Location location) {
            int lx = location.getBlockX();
            int ly = location.getBlockY();
            int lz = location.getBlockZ();
            int bx = this.base.getBlockX();
            int by = this.base.getBlockY();
            int bz = this.base.getBlockZ();
            return lx >= bx - 3 && lx <= bx + 3 && ly >= by && ly <= by + 4 && lz >= bz - 3 && lz <= bz + 3;
        }

        public void teleport(Player player, Plugin plugin, PortalSpell spell) {
            if (this.target == null) {
                return;
            }
            Location targetLocation = this.target.getLocation();
            Location playerLocation = player.getLocation();
            Location destination = new Location(targetLocation.getWorld(), targetLocation.getX(), targetLocation.getY() + 1.0, targetLocation.getZ(), playerLocation.getYaw(), playerLocation.getPitch());
            Server server = plugin.getServer();
            BukkitScheduler sched = server.getScheduler();
            sched.scheduleSyncDelayedTask(plugin, (Runnable)new TeleportPlayerTask(destination, spell), 0L);
        }

        public void link(PlayerPortal target) {
            this.target = target;
        }

        public void unlink() {
            this.target = null;
        }
    }

    public class TeleportPlayerTask
    implements Runnable {
        protected Location targetLocation;
        protected PortalSpell spell;

        public TeleportPlayerTask(Location target, PortalSpell spell) {
            this.targetLocation = target;
            this.spell = spell;
        }

        public void run() {
            this.spell.startTeleporting();
            this.spell.getPlayer().teleport(this.targetLocation);
        }
    }
}

