/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.utilities.URLMap;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class URLMapRenderer
extends MapRenderer {
    private static final String configurationFileName = "urlmaps.yml";
    private static Plugin plugin;
    private static YamlConfiguration configuration;
    private final URLMap map;

    protected static File getConfigurationFile() {
        File dataFolder = plugin.getDataFolder();
        return new File(dataFolder, configurationFileName);
    }

    public static void load(Plugin callingPlugin) {
        plugin = callingPlugin;
        configuration = new YamlConfiguration();
        File configurationFile = URLMapRenderer.getConfigurationFile();
        if (configurationFile.exists()) {
            try {
                configuration.load(configurationFile);
                Set maps = configuration.getKeys(false);
                for (String mapId : maps) {
                    ConfigurationSection mapConfig = configuration.getConfigurationSection(mapId);
                    try {
                        MapRenderer renderer2;
                        URLMap newMap = URLMap.get(Short.parseShort(mapId), mapConfig.getString("url"), mapConfig.getInt("x"), mapConfig.getInt("y"), mapConfig.getInt("width"), mapConfig.getInt("height"));
                        MapView playerMap = Bukkit.getMap((short)newMap.getId());
                        if (playerMap == null) {
                            throw new Exception("Failed to load map id " + newMap.getId() + " for url key " + newMap.getKey());
                        }
                        for (MapRenderer renderer2 : playerMap.getRenderers()) {
                            playerMap.removeRenderer(renderer2);
                        }
                        renderer2 = new URLMapRenderer(newMap);
                        playerMap.addRenderer(renderer2);
                    }
                    catch (Exception ex) {
                        plugin.getLogger().warning("Failed to load " + configurationFile.getAbsolutePath() + ": " + ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                plugin.getLogger().warning("Failed to load " + configurationFile.getAbsolutePath() + ": " + ex.getMessage());
            }
        }
    }

    public static void save() {
        if (configuration == null) {
            configuration = new YamlConfiguration();
        }
        File configurationFile = URLMapRenderer.getConfigurationFile();
        URLMap.save((ConfigurationSection)configuration);
        try {
            configuration.save(configurationFile);
        }
        catch (Exception ex) {
            plugin.getLogger().warning("Failed to save file " + configurationFile.getAbsolutePath());
        }
    }

    private URLMapRenderer(URLMap urlMap) {
        this.map = urlMap;
    }

    public URLMapRenderer(String url, int x, int y, int width, int height) {
        this(URLMap.get(url, x, y, width, height));
    }

    public static ItemStack getMapItem(String name, MapView mapView) {
        ItemStack newMapItem = new ItemStack(Material.MAP, 1, mapView.getId());
        ItemMeta meta = newMapItem.getItemMeta();
        meta.setDisplayName(name);
        newMapItem.setItemMeta(meta);
        return newMapItem;
    }

    public static ItemStack getPlayerPortrait(String playerName) {
        MapView mapView = URLMapRenderer.getURL("http://s3.amazonaws.com/MinecraftSkins/" + playerName + ".png", 8, 8, 8, 8);
        return URLMapRenderer.getMapItem("Photo of " + playerName, mapView);
    }

    public static void forceReloadPlayerPortrait(String playerName) {
        URLMap map = URLMap.get("http://s3.amazonaws.com/MinecraftSkins/" + playerName + ".png", 8, 8, 8, 8);
        map.reload();
    }

    public static MapView getURL(String url) {
        return URLMapRenderer.getURL(url, 0, 0, 0, 0);
    }

    public static ItemStack getURLItem(String url, int x, int y, int width, int height, String name) {
        MapView mapView = URLMapRenderer.getURL(url, x, y, width, height);
        return URLMapRenderer.getMapItem(name, mapView);
    }

    public static MapView getURL(String url, int x, int y, int width, int height) {
        MapRenderer renderer2;
        World world = (World)Bukkit.getWorlds().get(0);
        MapView mapView = null;
        URLMap map = URLMap.get(url, x, y, width, height);
        if (map.getId() != null) {
            mapView = Bukkit.getMap((short)map.getId());
            plugin.getLogger().warning("Failed to get map id " + map.getId() + ", unregistering from key " + map.getKey());
            map.setId(null);
        }
        if (map.getId() == null) {
            mapView = Bukkit.createMap((World)world);
            if (mapView == null) {
                plugin.getLogger().warning("Failed to create a new map");
            } else {
                map.setId(mapView.getId());
            }
        }
        if (mapView == null) {
            return mapView;
        }
        for (MapRenderer renderer2 : mapView.getRenderers()) {
            mapView.removeRenderer(renderer2);
        }
        renderer2 = new URLMapRenderer(map);
        mapView.addRenderer(renderer2);
        return mapView;
    }

    public static void resend(String playerName) {
        URLMap.resend(playerName);
    }

    public static void forceReload(String url, int x, int y, int width, int height) {
        URLMap.get(url, x, y, width, height).reload();
    }

    public void render(MapView mapView, MapCanvas canvas, Player player) {
        if (this.map.isRendered()) {
            this.map.sendToPlayer(player, mapView);
            return;
        }
        BufferedImage image = this.map.getImage(plugin);
        if (image != null) {
            canvas.drawImage(0, 0, (Image)image);
            this.map.render();
        }
    }
}

