/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class URLMap {
    private static HashMap<String, URLMap> keyMap = new HashMap();
    private static HashMap<Short, URLMap> idMap = new HashMap();
    private Short id;
    private BufferedImage image;
    protected String url;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean rendered = false;
    protected volatile boolean loading = false;
    protected Set<String> sentToPlayers = new HashSet<String>();

    public static URLMap get(Short mapId, String url, int x, int y, int width, int height) {
        String key = URLMap.getKey(url, x, y, width, height);
        if (keyMap.containsKey(key)) {
            return keyMap.get(key);
        }
        URLMap newMap = new URLMap(mapId, url, x, y, width, height);
        keyMap.put(key, newMap);
        if (mapId != null) {
            idMap.put(mapId, newMap);
        }
        return newMap;
    }

    public static URLMap get(String url, int x, int y, int width, int height) {
        return URLMap.get(null, url, x, y, width, height);
    }

    public static void resend(String playerName) {
        for (URLMap map : keyMap.values()) {
            map.resendTo(playerName);
        }
    }

    public static void save(ConfigurationSection root) {
        for (URLMap map : keyMap.values()) {
            ConfigurationSection mapConfig = root.createSection(Short.toString(map.getId()));
            mapConfig.set("url", (Object)map.url);
            mapConfig.set("x", (Object)map.x);
            mapConfig.set("y", (Object)map.y);
            mapConfig.set("width", (Object)map.width);
            mapConfig.set("height", (Object)map.height);
        }
    }

    private URLMap(Short mapId, String url, int x, int y, int width, int height) {
        this.url = url;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.id = mapId;
    }

    private static String getKey(String url, int x, int y, int width, int height) {
        return x + "," + y + "|" + width + "," + height + "|" + url;
    }

    public String getKey() {
        return URLMap.getKey(this.url, this.x, this.y, this.width, this.height);
    }

    public Short getId() {
        return this.id;
    }

    public void setId(Short id) {
        if (this.id == id) {
            return;
        }
        if (this.id != null) {
            idMap.remove(this.id);
        }
        this.id = id;
        if (this.id != null) {
            idMap.put(this.id, this);
        }
    }

    public void resendTo(String playerName) {
        this.sentToPlayers.remove(playerName);
    }

    public void reload() {
        this.sentToPlayers.clear();
        this.rendered = false;
        this.loading = false;
        this.image = null;
    }

    public BufferedImage getImage(final Plugin plugin) {
        if (this.loading) {
            return null;
        }
        if (this.image == null) {
            this.loading = true;
            this.image = new BufferedImage(128, 128, 1);
            Bukkit.getScheduler().runTaskAsynchronously(plugin, new Runnable(){

                public void run() {
                    try {
                        plugin.getLogger().info("Loading " + URLMap.this.url);
                        URL connection = new URL(URLMap.this.url);
                        BufferedImage rawImage = ImageIO.read(connection);
                        URLMap.this.width = URLMap.this.width <= 0 ? rawImage.getWidth() + URLMap.this.width : URLMap.this.width;
                        URLMap.this.height = URLMap.this.height <= 0 ? rawImage.getHeight() + URLMap.this.height : URLMap.this.height;
                        BufferedImage croppedImage = rawImage.getSubimage(URLMap.this.x, URLMap.this.y, URLMap.this.width, URLMap.this.height);
                        Graphics2D graphics = URLMap.this.image.createGraphics();
                        AffineTransform transform = AffineTransform.getScaleInstance(128.0f / (float)URLMap.this.width, 128.0f / (float)URLMap.this.height);
                        graphics.drawRenderedImage(croppedImage, transform);
                        URLMap.this.loading = false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            return null;
        }
        return this.image;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public void render() {
        this.rendered = true;
    }

    public void sendToPlayer(Player player, MapView mapView) {
        String playerName = player.getName();
        if (!this.sentToPlayers.contains(playerName)) {
            this.sentToPlayers.add(playerName);
            player.sendMap(mapView);
        }
    }
}

