/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.utilities.WeightedPair;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomUtils {
    private static final Random random = new Random();

    public static <T> void populateProbabilityMap(Class<T> valueClass, LinkedList<WeightedPair<T>> probabilityMap, ConfigurationNode nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        Float currentThreshold = Float.valueOf(0.0f);
        if (nodeMap != null) {
            List<String> keys = nodeMap.getKeys();
            for (String key : keys) {
                currentThreshold = Float.valueOf(currentThreshold.floatValue() + RandomUtils.lerp(nodeMap.getString(key).split(","), levelIndex, nextLevelIndex, distance));
                probabilityMap.add(new WeightedPair<T>(currentThreshold, key, valueClass));
            }
        }
    }

    public static void populateFloatProbabilityMap(LinkedList<WeightedPair<Float>> probabilityMap, ConfigurationNode nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Float.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateStringProbabilityMap(LinkedList<WeightedPair<String>> probabilityMap, ConfigurationNode nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(String.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateIntegerProbabilityMap(LinkedList<WeightedPair<Integer>> probabilityMap, ConfigurationNode nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Integer.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static float lerp(String[] list, int levelIndex, int nextLevelIndex, float distance) {
        float previousValue = Float.parseFloat(list[levelIndex]);
        float nextValue = Float.parseFloat(list[nextLevelIndex]);
        return previousValue + distance * (nextValue - previousValue);
    }

    public static <T> T weightedRandom(LinkedList<WeightedPair<T>> weightList) {
        if (weightList.size() == 0) {
            return null;
        }
        Float maxWeight = weightList.getLast().getThreshold();
        Float selectedWeight = Float.valueOf(random.nextFloat() * maxWeight.floatValue());
        for (WeightedPair weightedPair : weightList) {
            if (!(selectedWeight.floatValue() < weightedPair.getThreshold().floatValue())) continue;
            return weightedPair.getValue();
        }
        return weightList.getFirst().getValue();
    }
}

