/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.blocks;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.blocks.BlockBatch;
import com.elmakers.mine.bukkit.plugins.magic.blocks.ConstructionType;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructBatch
implements BlockBatch {
    private int timeToLive = 0;
    private final Set<Material> indestructible;
    private final BlockList constructedBlocks = new BlockList();
    private final Location center;
    private final int radius;
    private final Material material;
    private final byte data;
    private boolean checkDestructible = true;
    private final ConstructionType type;
    private final boolean fill;
    private final PlayerSpells playerSpells;
    private final Spell spell;
    private boolean finished = false;
    private int x = 0;
    private int y = 0;
    private int z = 0;

    public ConstructBatch(Spell spell, Location center, ConstructionType type, int radius, boolean fill, Material material, byte data, Set<Material> indestructible) {
        this.indestructible = indestructible;
        this.center = center;
        this.radius = radius;
        this.material = material;
        this.data = data;
        this.type = type;
        this.fill = fill;
        this.playerSpells = spell.getPlayerSpells();
        this.spell = spell;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        Spells spells = this.playerSpells.getMaster();
        Player player = this.playerSpells.getPlayer();
        while (processedBlocks <= maxBlocks && this.x <= this.radius) {
            if (!this.fillBlock(this.x, this.y, this.z)) {
                return processedBlocks;
            }
            ++this.y;
            if (this.y > this.radius) {
                this.y = 0;
                ++this.z;
                if (this.z > this.radius) {
                    this.z = 0;
                    ++this.x;
                }
            }
            ++processedBlocks;
        }
        if (!this.finished && this.x > this.radius) {
            this.finished = true;
            if (this.timeToLive == 0) {
                spells.addToUndoQueue(player, this.constructedBlocks);
            } else {
                this.constructedBlocks.setTimeToLive(this.timeToLive);
                spells.scheduleCleanup(this.constructedBlocks);
            }
            this.spell.castMessage("Constructed " + this.constructedBlocks.size() + " blocks");
        }
        return processedBlocks;
    }

    public boolean fillBlock(int x, int y, int z) {
        boolean fillBlock = false;
        switch (this.type) {
            case SPHERE: {
                int maxDistanceSquared = this.radius * this.radius;
                float mx = (float)x - 0.5f;
                float my = (float)y - 0.5f;
                float mz = (float)z - 0.5f;
                int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                if (this.fill) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case PYRAMID: {
                int elevation = this.radius - y;
                if (this.fill) {
                    fillBlock = x <= elevation && z <= elevation;
                    break;
                }
                fillBlock = x == elevation && z <= elevation || z == elevation && x <= elevation;
                break;
            }
            default: {
                fillBlock = this.fill ? true : x == this.radius || y == this.radius || z == this.radius;
            }
        }
        boolean success = true;
        if (fillBlock) {
            success = success && this.constructBlock(x, y, z);
            success = success && this.constructBlock(-x, y, z);
            success = success && this.constructBlock(x, -y, z);
            success = success && this.constructBlock(x, y, -z);
            success = success && this.constructBlock(-x, -y, z);
            success = success && this.constructBlock(x, -y, -z);
            success = success && this.constructBlock(-x, y, -z);
            success = success && this.constructBlock(-x, -y, -z);
        }
        return success;
    }

    public int getDistanceSquared(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    public boolean constructBlock(int dx, int dy, int dz) {
        int x = this.center.getBlockX() + dx;
        int y = this.center.getBlockY() + dy;
        int z = this.center.getBlockZ() + dz;
        if (y < 0 || y > 255) {
            return true;
        }
        Block block = this.center.getWorld().getBlockAt(x, y, z);
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load();
            return false;
        }
        if (this.checkDestructible && !this.isDestructible(block)) {
            return true;
        }
        if (!this.playerSpells.hasBuildPermission(block)) {
            return true;
        }
        this.constructedBlocks.add(block);
        block.setType(this.material);
        block.setData(this.data);
        return true;
    }

    protected boolean isDestructible(Block block) {
        return this.playerSpells.getMaster().getDestructibleMaterials().contains(block.getType()) && !this.indestructible.contains(block.getType());
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setCheckDestructible(boolean check) {
        this.checkDestructible = check;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

