/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.dao.BlockList;
import java.util.LinkedList;
import org.bukkit.block.Block;

public class UndoQueue {
    private final LinkedList<BlockList> blockQueue = new LinkedList();
    private int maxSize = 0;

    public void add(BlockList blocks) {
        if (this.maxSize > 0 && this.blockQueue.size() > this.maxSize) {
            this.blockQueue.removeFirst();
        }
        this.blockQueue.add(blocks);
    }

    public BlockList getLast() {
        if (this.blockQueue.isEmpty()) {
            return null;
        }
        return this.blockQueue.getLast();
    }

    public BlockList getLast(Block target) {
        if (this.blockQueue.size() == 0) {
            return null;
        }
        for (BlockList blocks : this.blockQueue) {
            if (!blocks.contains(target)) continue;
            return blocks;
        }
        return null;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public boolean undo() {
        if (this.blockQueue.size() == 0) {
            return false;
        }
        BlockList blocks = this.blockQueue.removeLast();
        if (!blocks.undo()) {
            this.blockQueue.add(blocks);
            return false;
        }
        return true;
    }

    public boolean undo(Block target) {
        BlockList lastActionOnTarget = this.getLast(target);
        if (lastActionOnTarget == null) {
            return false;
        }
        this.blockQueue.remove(lastActionOnTarget);
        lastActionOnTarget.undo();
        return true;
    }
}

