/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightSource {
    private static String versionPrefix = "";
    private static Class<?> class_World;
    private static Class<?> class_Packet;
    private static Class<Enum> class_EnumSkyBlock;
    private static Class<?> class_PacketPlayOutMapChunkBulk;
    private static Class<?> class_Packet56MapChunkBulk;

    static {
        String className = Bukkit.getServer().getClass().getName();
        String[] packages = className.split("\\.");
        if (packages.length == 5) {
            versionPrefix = String.valueOf(packages[3]) + ".";
        }
        try {
            class_Packet = LightSource.fixBukkitClass("net.minecraft.server.Packet");
            class_World = LightSource.fixBukkitClass("net.minecraft.server.World");
            class_EnumSkyBlock = LightSource.fixBukkitClass("net.minecraft.server.EnumSkyBlock");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            class_PacketPlayOutMapChunkBulk = LightSource.fixBukkitClass("net.minecraft.server.PacketPlayOutMapChunkBulk");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            class_Packet56MapChunkBulk = LightSource.fixBukkitClass("net.minecraft.server.Packet56MapChunkBulk");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (class_PacketPlayOutMapChunkBulk == null && class_Packet56MapChunkBulk == null) {
            System.err.println("Could not bind to either PlayOutMapChunk packet version");
        }
    }

    private static Class<?> fixBukkitClass(String className) throws Exception {
        className = className.replace("org.bukkit.craftbukkit.", "org.bukkit.craftbukkit." + versionPrefix);
        className = className.replace("net.minecraft.server.", "net.minecraft.server." + versionPrefix);
        return Class.forName(className);
    }

    protected static Object getHandle(World world) {
        Object handle = null;
        try {
            Method handleMethod = world.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)world, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static Object getHandle(Chunk chunk) {
        Object handle = null;
        try {
            Method handleMethod = chunk.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)chunk, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static Object getHandle(Player player) {
        Object handle = null;
        try {
            Method handleMethod = player.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)player, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    public static void createLightSource(Location l, int level) {
        LightSource.createLightSource(l, level, null);
    }

    public static void createLightSource(Location l, int level, Collection<Player> players) {
        byte oLevel = l.getBlock().getLightLevel();
        Enum blockEnum = Enum.valueOf(class_EnumSkyBlock, "Block");
        Method addLightMethod = null;
        Object worldHandle = LightSource.getHandle(l.getWorld());
        try {
            addLightMethod = class_World.getMethod("b", class_EnumSkyBlock, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable ex) {
            addLightMethod = null;
            ex.printStackTrace();
        }
        if (worldHandle == null || addLightMethod == null) {
            return;
        }
        try {
            addLightMethod.invoke(worldHandle, blockEnum, l.getBlockX(), l.getBlockY(), l.getBlockZ(), level);
            LightSource.updateChunk(l, players);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            addLightMethod.invoke(worldHandle, blockEnum, l.getBlockX(), l.getBlockY(), l.getBlockZ(), oLevel);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void deleteLightSource(Location l) {
        LightSource.deleteLightSource(l, null);
    }

    public static void deleteLightSource(Location l, Collection<Player> players) {
        int t = l.getBlock().getTypeId();
        l.getBlock().setTypeId(t == 1 ? 2 : 1);
        LightSource.updateChunk(l, players);
        l.getBlock().setTypeId(t);
    }

    private static void updateChunk(Location l, Collection<Player> players) {
        try {
            Constructor<?> packetConstructor;
            ArrayList<Object> chunks = new ArrayList<Object>();
            int x = -1;
            while (x <= 1) {
                int z = -1;
                while (z <= 1) {
                    chunks.add(LightSource.getHandle(l.clone().add((double)(16 * x), 0.0, (double)(16 * z)).getChunk()));
                    ++z;
                }
                ++x;
            }
            Object packet = null;
            if (class_PacketPlayOutMapChunkBulk != null) {
                packetConstructor = class_PacketPlayOutMapChunkBulk.getConstructor(List.class);
                packet = packetConstructor.newInstance(chunks);
            } else {
                packetConstructor = class_Packet56MapChunkBulk.getConstructor(List.class);
                packet = packetConstructor.newInstance(chunks);
            }
            int t = l.clone().add(0.0, 1.0, 0.0).getBlock().getTypeId();
            l.clone().add(0.0, 1.0, 0.0).getBlock().setTypeId(t == 1 ? 2 : 1);
            players = players != null && players.size() > 0 ? players : l.getWorld().getPlayers();
            for (Player player : players) {
                if (!(player.getLocation().distance(l) <= (double)(Bukkit.getServer().getViewDistance() * 16))) continue;
                Object playerHandle = LightSource.getHandle(player);
                Field connectionField = playerHandle.getClass().getField("playerConnection");
                Object connection = connectionField.get(playerHandle);
                Method sendPacketMethod = connection.getClass().getMethod("sendPacket", class_Packet);
                sendPacketMethod.invoke(connection, packet);
            }
            l.clone().add(0.0, 1.0, 0.0).getBlock().setTypeId(t);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

