/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class PushSpell
extends Spell {
    int itemMagnitude = 1;
    int entityMagnitude = 3;
    int maxAllDistance = 20;
    boolean allowAll = true;

    public void forceAll(double mutliplier, boolean pull) {
        List entities = this.player.getWorld().getEntities();
        for (Entity target : entities) {
            Location targetLocation;
            Location playerLocation;
            if (target == this.player || (playerLocation = this.player.getLocation()).distanceSquared(targetLocation = target.getLocation()) > (double)(this.maxAllDistance * this.maxAllDistance)) continue;
            Location to = pull ? targetLocation : playerLocation;
            Location from = pull ? playerLocation : targetLocation;
            this.forceEntity(target, mutliplier, from, to);
        }
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean push = false;
        boolean pull = false;
        String typeString = parameters.getString("type", "");
        push = typeString.equals("push");
        pull = typeString.equals("pull");
        double multiplier = parameters.getDouble("size", 1.0);
        this.targetEntity(Entity.class);
        List<Target> targets = this.getAllTargetEntities();
        if (this.allowAll && targets.size() == 0 && (this.getYRotation() < -60.0 || this.getYRotation() > 60.0)) {
            if (push) {
                this.castMessage("Get away!");
            } else {
                this.castMessage("Gimme!");
            }
            this.forceAll(multiplier, pull);
            return SpellResult.SUCCESS;
        }
        if (targets.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        for (Target target : targets) {
            Entity targetEntity = target.getEntity();
            Location to = pull ? target.getLocation() : this.player.getLocation();
            Location from = pull ? this.player.getLocation() : target.getLocation();
            this.forceEntity(targetEntity, multiplier, from, to);
        }
        if (pull) {
            this.castMessage("Yoink!");
        } else {
            this.castMessage("Shove!");
        }
        return SpellResult.SUCCESS;
    }

    protected void forceEntity(Entity target, double multiplier, Location from, Location to) {
        Vector fromVector;
        int magnitude = target instanceof LivingEntity ? this.entityMagnitude : this.itemMagnitude;
        magnitude = (int)((double)magnitude * multiplier);
        Vector toVector = new Vector(to.getBlockX(), to.getBlockY(), to.getBlockZ());
        Vector forceVector = fromVector = new Vector(from.getBlockX(), from.getBlockY(), from.getBlockZ());
        forceVector.subtract(toVector);
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }

    public void onLoad(ConfigurationNode properties) {
        this.itemMagnitude = properties.getInt("item_force", this.itemMagnitude);
        this.entityMagnitude = properties.getInt("entity_force", this.entityMagnitude);
        this.allowAll = properties.getBoolean("allow_area", this.allowAll);
        this.maxAllDistance = properties.getInt("area_range", this.maxAllDistance);
    }
}

