/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class GotoSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        String playerName = parameters.getString("player");
        Player targetPlayer = null;
        if (playerName != null) {
            targetPlayer = this.spells.getPlugin().getServer().getPlayer(playerName);
        }
        this.targetEntity(Player.class);
        if (this.getYRotation() > 80.0) {
            Player destination = this.getFarthestPlayer(this.player);
            if (destination == null) {
                return SpellResult.NO_TARGET;
            }
            this.player.teleport((Entity)destination);
            this.castMessage("Teleporting you to " + destination.getName());
            return SpellResult.SUCCESS;
        }
        Target target = this.getTarget();
        Entity targetEntity = target.getEntity();
        if (targetEntity != null && targetEntity instanceof Player) {
            Player targetedPlayer = (Player)targetEntity;
            Player destination = this.getFarthestPlayer(targetedPlayer);
            if (destination == null) {
                return SpellResult.NO_TARGET;
            }
            targetedPlayer.teleport((Entity)destination);
            this.castMessage("Teleporting " + targetedPlayer.getName() + " to " + destination.getName());
            return SpellResult.SUCCESS;
        }
        Location destination = this.player.getLocation();
        if (target.isBlock()) {
            destination = target.getLocation();
            destination.setY(destination.getY() + 1.0);
        }
        if (targetPlayer == null) {
            targetPlayer = this.getFarthestPlayer(this.player);
        }
        if (targetPlayer == null) {
            return SpellResult.NO_TARGET;
        }
        targetPlayer.teleport(destination);
        this.castMessage("Teleporting " + targetPlayer.getName() + " to your target");
        return SpellResult.SUCCESS;
    }

    protected Player getFarthestPlayer(Player fromPlayer) {
        Player destinationPlayer = null;
        List players = fromPlayer.getLocation().getWorld().getPlayers();
        double targetToDestinationDistance = 0.0;
        for (Player d : players) {
            if (d == fromPlayer) continue;
            double dd = d.getLocation().distanceSquared(fromPlayer.getLocation());
            if (destinationPlayer != null && !(dd > targetToDestinationDistance)) continue;
            targetToDestinationDistance = dd;
            destinationPlayer = d;
        }
        return destinationPlayer;
    }
}

