/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class ForceSpell
extends Spell {
    int magnitude = 3;
    LivingEntity targetEntity = null;

    public SpellResult onCast(ConfigurationNode parameters) {
        if (this.targetEntity != null && this.targetEntity instanceof LivingEntity) {
            if (!this.targetEntity.isValid() || this.targetEntity.isDead()) {
                this.targetEntity = null;
            }
            if (this.targetEntity != null && this.player.getLocation().distanceSquared(this.targetEntity.getLocation()) > (double)this.getMaxRangeSquared()) {
                this.targetEntity = null;
            }
        }
        if (this.targetEntity == null) {
            this.targetEntity(LivingEntity.class);
            Target target = this.getTarget();
            if (!(target != null && target.hasTarget() && target.isEntity() && target.getEntity() instanceof LivingEntity)) {
                this.targetEntity = null;
                return SpellResult.NO_TARGET;
            }
            this.targetEntity = (LivingEntity)target.getEntity();
            return SpellResult.COST_FREE;
        }
        double multiplier = parameters.getDouble("size", 1.0);
        this.forceEntity((Entity)this.targetEntity, multiplier);
        return SpellResult.SUCCESS;
    }

    protected void forceEntity(Entity target, double multiplier) {
        this.magnitude = (int)((double)this.magnitude * multiplier);
        Vector forceVector = this.getAimVector();
        forceVector.normalize();
        forceVector.multiply(this.magnitude);
        target.setVelocity(forceVector);
    }

    public boolean onCancel() {
        if (this.targetEntity != null) {
            if (this.targetEntity instanceof LivingEntity && !this.targetEntity.isDead() && this.player.getLocation().distanceSquared(this.targetEntity.getLocation()) > (double)this.getMaxRangeSquared()) {
                this.castMessage("Released target");
            }
            this.targetEntity = null;
            return true;
        }
        return false;
    }

    public void onLoad(ConfigurationNode properties) {
        this.magnitude = properties.getInt("entity_force", this.magnitude);
    }
}

