/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;

public class BoomSpell
extends Spell {
    protected int defaultSize = 1;

    public SpellResult createExplosionAt(Location target, float size, boolean incendiary, boolean breakBlocks) {
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Location l = target.getBlock().getLocation();
        this.player.getWorld().createExplosion(l.getX(), l.getY(), l.getZ(), size, incendiary, breakBlocks);
        return SpellResult.SUCCESS;
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        boolean useFire = parameters.getBoolean("fire", false);
        boolean breakBlocks = parameters.getBoolean("break_blocks", true);
        String targetType = parameters.getString("target", "");
        size = (int)(this.playerSpells.getPowerMultiplier() * (float)size);
        if (targetType.equals("here")) {
            this.player.damage(this.player.getMaxHealth() * 10.0);
            return this.createExplosionAt(this.player.getLocation(), size, useFire, breakBlocks);
        }
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        return this.createExplosionAt(target.getLocation(), size, useFire, breakBlocks);
    }
}

