/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.WandLevel;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wand
implements CostReducer {
    private ItemStack item;
    private Spells spells;
    private PlayerSpells activePlayer;
    private String id;
    private String wandSpells = "";
    private String wandMaterials = "";
    private String activeSpell = "";
    private String activeMaterial = "";
    private String wandName = "";
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private float power = 0.0f;
    private boolean hasInventory = false;
    private int uses = 0;
    private int xp = 0;
    private int xpRegeneration = 0;
    private int xpMax = 50;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private int effectColor = 0;
    private float defaultWalkSpeed = 0.2f;
    private float defaultFlySpeed = 0.1f;
    private float speedIncrease = 0.0f;
    private int storedXpLevel = 0;
    private int storedXp = 0;
    private float storedXpProgress = 0.0f;
    private static DecimalFormat floatFormat = new DecimalFormat("#.###");
    public static Material WandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = Material.WOOD_SWORD;
    public static Material EraseMaterial = Material.SULPHUR;
    public static Material CopyMaterial = Material.PUMPKIN_SEEDS;
    protected static Map<String, ConfigurationNode> wandTemplates = new HashMap<String, ConfigurationNode>();
    private static final String propertiesFileName = "wands.yml";
    private static final String propertiesFileNameDefaults = "wands.defaults.yml";
    private static final String defaultWandName = "Wand";

    public Wand(Spells spells) {
        this.spells = spells;
        this.item = new ItemStack(WandMaterial);
        this.item = InventoryUtils.getCopy(this.item);
        ItemMeta itemMeta = this.item.getItemMeta();
        this.item.setItemMeta(itemMeta);
        InventoryUtils.addGlow(this.item);
        this.id = UUID.randomUUID().toString();
        this.wandName = defaultWandName;
        this.updateName();
        this.saveState();
    }

    public Wand(Spells spells, ItemStack item) {
        this.item = item;
        this.spells = spells;
        this.loadState();
    }

    public void setActiveSpell(String activeSpell) {
        this.activeSpell = activeSpell;
        this.updateName();
        this.updateInventoryNames(true);
        this.saveState();
    }

    public void setActiveMaterial(Material material, byte data) {
        String materialKey = "";
        materialKey = material == CopyMaterial ? "-1:0" : (material == EraseMaterial ? "0:0" : material.getId() + ":" + data);
        this.setActiveMaterial(materialKey);
    }

    protected void setActiveMaterial(String materialKey) {
        this.activeMaterial = materialKey;
        this.updateName();
        this.updateActiveMaterial();
        this.updateInventoryNames(true);
        this.saveState();
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public int getXpMax() {
        return this.xpMax;
    }

    public int getExperience() {
        return this.xp;
    }

    public void removeExperience(int amount) {
        this.xp = Math.max(0, this.xp - amount);
        this.updateMana();
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    @Override
    public float getCostReduction() {
        return this.costReduction;
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public float getPower() {
        return this.power;
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    public int getUses() {
        return this.uses;
    }

    public String getName() {
        return this.wandName;
    }

    protected void setName(String name) {
        this.wandName = name;
        this.updateName();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    protected void saveState() {
        Object wandNode = InventoryUtils.createNode(this.item, "wand");
        InventoryUtils.setMeta(wandNode, "id", this.id);
        InventoryUtils.setMeta(wandNode, "materials", this.wandMaterials);
        InventoryUtils.setMeta(wandNode, "spells", this.wandSpells);
        InventoryUtils.setMeta(wandNode, "active_spell", this.activeSpell);
        InventoryUtils.setMeta(wandNode, "active_material", this.activeMaterial);
        InventoryUtils.setMeta(wandNode, "name", this.wandName);
        InventoryUtils.setMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction));
        InventoryUtils.setMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction));
        InventoryUtils.setMeta(wandNode, "power", floatFormat.format(this.power));
        InventoryUtils.setMeta(wandNode, "protection", floatFormat.format(this.damageReduction));
        InventoryUtils.setMeta(wandNode, "protection_physical", floatFormat.format(this.damageReductionPhysical));
        InventoryUtils.setMeta(wandNode, "protection_projectiles", floatFormat.format(this.damageReductionProjectiles));
        InventoryUtils.setMeta(wandNode, "protection_falling", floatFormat.format(this.damageReductionFalling));
        InventoryUtils.setMeta(wandNode, "protection_fire", floatFormat.format(this.damageReductionFire));
        InventoryUtils.setMeta(wandNode, "protection_explosions", floatFormat.format(this.damageReductionExplosions));
        InventoryUtils.setMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction));
        InventoryUtils.setMeta(wandNode, "haste", floatFormat.format(this.speedIncrease));
        InventoryUtils.setMeta(wandNode, "xp", Integer.toString(this.xp));
        InventoryUtils.setMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration));
        InventoryUtils.setMeta(wandNode, "xp_max", Integer.toString(this.xpMax));
        InventoryUtils.setMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration));
        InventoryUtils.setMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration));
        InventoryUtils.setMeta(wandNode, "uses", Integer.toString(this.uses));
        InventoryUtils.setMeta(wandNode, "has_inventory", Integer.toString(this.hasInventory ? 1 : 0));
        InventoryUtils.setMeta(wandNode, "effect_color", Integer.toString(this.effectColor, 16));
    }

    protected void loadOldState(ItemStack item) {
        String[] wandPairs;
        this.id = InventoryUtils.getMeta(item, "magic_wand_id");
        this.id = this.id == null || this.id.length() == 0 ? UUID.randomUUID().toString() : this.id;
        String wandSettings = InventoryUtils.getMeta(item, "magic_wand");
        wandSettings = wandSettings == null ? "" : wandSettings;
        this.wandMaterials = InventoryUtils.getMeta(item, "magic_materials");
        this.wandMaterials = this.wandMaterials == null ? "" : this.wandMaterials;
        this.wandSpells = InventoryUtils.getMeta(item, "magic_spells");
        this.wandSpells = this.wandSpells == null ? "" : this.wandSpells;
        this.activeSpell = InventoryUtils.getMeta(item, "magic_active_spell");
        this.activeSpell = this.activeSpell == null ? "" : this.activeSpell;
        this.activeMaterial = InventoryUtils.getMeta(item, "magic_active_material");
        this.activeMaterial = this.activeMaterial == null ? "" : this.activeMaterial;
        this.wandName = InventoryUtils.getMeta(item, "magic_wand_name");
        this.wandName = this.wandName == null ? defaultWandName : this.wandName;
        for (String pair : wandPairs = StringUtils.split((String)wandSettings, (String)"&")) {
            String[] keyValue = StringUtils.split((String)pair, (String)"=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            float value = Float.parseFloat(keyValue[1]);
            if (key.equalsIgnoreCase("cr")) {
                this.costReduction = value;
                continue;
            }
            if (key.equalsIgnoreCase("cdr")) {
                this.cooldownReduction = value;
                continue;
            }
            if (key.equalsIgnoreCase("dr")) {
                this.damageReduction = value;
                continue;
            }
            if (key.equalsIgnoreCase("drph")) {
                this.damageReductionPhysical = value;
                continue;
            }
            if (key.equalsIgnoreCase("drpr")) {
                this.damageReductionProjectiles = value;
                continue;
            }
            if (key.equalsIgnoreCase("drfa")) {
                this.damageReductionFalling = value;
                continue;
            }
            if (key.equalsIgnoreCase("drfi")) {
                this.damageReductionFire = value;
                continue;
            }
            if (key.equalsIgnoreCase("drex")) {
                this.damageReductionExplosions = value;
                continue;
            }
            if (key.equalsIgnoreCase("uses")) {
                this.uses = (int)value;
                continue;
            }
            if (key.equalsIgnoreCase("xpre")) {
                this.xpRegeneration = (int)value;
                continue;
            }
            if (key.equalsIgnoreCase("xpmax")) {
                this.xpMax = (int)value;
                continue;
            }
            if (key.equalsIgnoreCase("hereg")) {
                this.healthRegeneration = (int)value;
                continue;
            }
            if (key.equalsIgnoreCase("hureg")) {
                this.hungerRegeneration = (int)value;
                continue;
            }
            if (!key.equalsIgnoreCase("hasi")) continue;
            this.hasInventory = (int)value != 0;
        }
    }

    protected void loadState() {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            this.loadOldState(this.item);
            return;
        }
        this.id = InventoryUtils.getMeta(wandNode, "id");
        this.id = this.id == null || this.id.length() == 0 ? UUID.randomUUID().toString() : this.id;
        this.wandMaterials = InventoryUtils.getMeta(wandNode, "materials", this.wandMaterials);
        this.wandSpells = InventoryUtils.getMeta(wandNode, "spells", this.wandSpells);
        this.activeSpell = InventoryUtils.getMeta(wandNode, "active_spell", this.activeSpell);
        this.activeMaterial = InventoryUtils.getMeta(wandNode, "active_material", this.activeMaterial);
        this.wandName = InventoryUtils.getMeta(wandNode, "name", this.wandName);
        this.costReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction)));
        this.cooldownReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction)));
        this.power = Float.parseFloat(InventoryUtils.getMeta(wandNode, "power", floatFormat.format(this.power)));
        this.damageReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection", floatFormat.format(this.damageReduction)));
        this.damageReductionPhysical = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_physical", floatFormat.format(this.damageReductionPhysical)));
        this.damageReductionProjectiles = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_projectiles", floatFormat.format(this.damageReductionProjectiles)));
        this.damageReductionFalling = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_falling", floatFormat.format(this.damageReductionFalling)));
        this.damageReductionFire = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_fire", floatFormat.format(this.damageReductionFire)));
        this.damageReductionExplosions = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_explosions", floatFormat.format(this.damageReductionExplosions)));
        this.cooldownReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction)));
        this.speedIncrease = Float.parseFloat(InventoryUtils.getMeta(wandNode, "haste", floatFormat.format(this.speedIncrease)));
        this.xp = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp", Integer.toString(this.xp)));
        this.xpRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration)));
        this.xpMax = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_max", Integer.toString(this.xpMax)));
        this.healthRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration)));
        this.hungerRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration)));
        this.uses = Integer.parseInt(InventoryUtils.getMeta(wandNode, "uses", Integer.toString(this.uses)));
        this.hasInventory = Integer.parseInt(InventoryUtils.getMeta(wandNode, "has_inventory", this.hasInventory ? "1" : "0")) != 0;
        this.effectColor = Integer.parseInt(InventoryUtils.getMeta(wandNode, "effect_color", Integer.toString(this.effectColor, 16)), 16);
        this.speedIncrease = Math.min(WandLevel.maxSpeedIncrease, this.speedIncrease);
    }

    public void removeMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = materialString + ":" + data;
        String[] materials = this.getMaterials();
        String fallbackActiveMaterial = "";
        LinkedList<String> materialMap = new LinkedList<String>();
        for (int i = 0; i < materials.length; ++i) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (pieces.length <= 0 || pieces[0].equals(materialString)) continue;
            fallbackActiveMaterial = materials[i];
            materialMap.add(materials[i]);
        }
        this.setMaterials(materialMap);
        if (materialString.equalsIgnoreCase(this.activeMaterial)) {
            this.activeMaterial = fallbackActiveMaterial;
            this.updateActiveMaterial();
            this.updateName();
            if (this.isInventoryOpen()) {
                this.updateInventory();
            }
        }
    }

    public boolean addMaterial(Material material, byte data) {
        return this.addMaterial(material, data, true);
    }

    protected boolean addMaterial(String materialString, boolean makeActive) {
        String[] materials = this.getMaterials();
        TreeSet<String> materialMap = new TreeSet<String>();
        for (int i = 0; i < materials.length; ++i) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            materialMap.add(pieces[0]);
        }
        if (makeActive || this.activeMaterial == null || this.activeMaterial.length() == 0) {
            this.activeMaterial = materialString;
        }
        boolean addedNew = !materialMap.contains(materialString);
        materialMap.add(materialString);
        this.setMaterials(materialMap);
        this.updateActiveMaterial();
        this.updateName();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return addedNew;
    }

    public boolean addMaterial(Material material, byte data, boolean makeActive) {
        Integer id = material.getId();
        String materialString = id.toString();
        if (material == EraseMaterial) {
            materialString = "0";
        } else if (material == CopyMaterial) {
            materialString = "-1";
        }
        materialString = materialString + ":" + data;
        return this.addMaterial(materialString, makeActive);
    }

    private void setMaterials(Collection<String> materialNames) {
        this.wandMaterials = StringUtils.join(materialNames, (String)"|");
        this.setMaterialCount(materialNames.size());
        String[] spellNames = this.getSpells();
        this.hasInventory = spellNames.length + materialNames.size() > 1;
        this.saveState();
    }

    public String[] getMaterials() {
        return StringUtils.split((String)this.wandMaterials, (String)"|");
    }

    private boolean addSpells(Collection<String> spellNames) {
        String[] spells = this.getSpells();
        TreeSet<String> spellMap = new TreeSet<String>();
        boolean addedNew = false;
        for (String spell : spells) {
            String[] pieces = spell.split("@");
            spellMap.add(pieces[0]);
        }
        for (String spellName : spellNames) {
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                this.activeSpell = spellName;
            }
            if (!spellMap.contains(spellName)) {
                addedNew = true;
            }
            spellMap.add(spellName);
            addedNew = true;
        }
        this.setSpells(spellMap);
        return addedNew;
    }

    public String[] getSpells() {
        return StringUtils.split((String)this.wandSpells, (String)"|");
    }

    public void removeSpell(String spellName) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        String fallbackActive = "";
        for (int i = 0; i < spells.length; ++i) {
            String[] pieces = StringUtils.split((String)spells[i], (String)"@");
            if (pieces.length <= 0 || pieces[0].equals(spellName)) continue;
            fallbackActive = spells[i];
            spellMap.add(spells[i]);
        }
        this.setSpells(spellMap);
        if (spellName.equalsIgnoreCase(this.activeSpell)) {
            this.activeSpell = fallbackActive;
            this.updateName();
            if (this.isInventoryOpen()) {
                this.updateInventory();
            }
        }
    }

    public boolean addSpell(String spellName, boolean makeDefault) {
        if (makeDefault) {
            this.activeSpell = spellName;
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add(spellName);
        boolean addedNew = this.addSpells(names);
        this.updateName();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return addedNew;
    }

    public boolean addSpell(String spellName) {
        return this.addSpell(spellName, true);
    }

    private void setSpells(Collection<String> spellNames) {
        this.wandSpells = StringUtils.join(spellNames, (String)"|");
        this.setSpellCount(spellNames.size());
        String[] materials = this.getMaterials();
        this.hasInventory = spellNames.size() + materials.length > 1;
        this.saveState();
    }

    private void setSpellCount(int spellCount) {
        this.updateLore(spellCount, this.getMaterials().length);
    }

    private void setMaterialCount(int materialCount) {
        this.updateLore(this.getSpells().length, materialCount);
    }

    private String getActiveWandName(Spell spell, String materialName) {
        int remaining;
        String name = this.wandName;
        if (this.hasInventory && spell != null) {
            if (materialName != null) {
                materialName = materialName.replace('_', ' ');
                name = ChatColor.GOLD + spell.getName() + ChatColor.GRAY + " " + materialName + ChatColor.WHITE + " (" + this.wandName + ")";
            } else {
                name = ChatColor.GOLD + spell.getName() + ChatColor.WHITE + " (" + this.wandName + ")";
            }
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            name = name + " : " + ChatColor.RED + "" + remaining + " Uses ";
        }
        return name;
    }

    private String getActiveWandName(Spell spell) {
        String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
        String materialName = null;
        if (spell != null && spell.usesMaterial() && !spell.hasMaterialOverride() && pieces.length > 0 && pieces[0].length() > 0) {
            int materialId = Integer.parseInt(pieces[0]);
            if (materialId == 0) {
                materialName = "erase";
            } else if (materialId == -1) {
                materialName = "copy";
            } else {
                Material material = Material.getMaterial((int)materialId);
                materialName = material.name().toLowerCase();
            }
        }
        return this.getActiveWandName(spell, materialName);
    }

    private String getMaterialName(Material material) {
        return this.getMaterialName(material, (byte)0);
    }

    private String getMaterialName(Material material, byte data) {
        String materialName = null;
        if (material == EraseMaterial) {
            materialName = "erase";
        } else if (material == CopyMaterial) {
            materialName = "copy";
        } else {
            materialName = material.name().toLowerCase();
            if (material == Material.CARPET || material == Material.STAINED_GLASS || material == Material.STAINED_CLAY || material == Material.STAINED_GLASS_PANE || material == Material.WOOL) {
                DyeColor color = DyeColor.getByWoolData((byte)data);
                materialName = color.name().toLowerCase().replace('_', ' ') + " " + materialName;
            } else if (material == Material.WOOD || material == Material.LOG || material == Material.SAPLING || material == Material.LEAVES) {
                TreeSpecies treeSpecies = TreeSpecies.getByData((byte)data);
                materialName = treeSpecies.name().toLowerCase().replace('_', ' ') + " " + materialName;
            }
        }
        materialName = materialName.replace('_', ' ');
        return materialName;
    }

    private String getActiveWandName(Material material) {
        Spell spell = this.spells.getSpell(this.activeSpell);
        String materialName = null;
        if (spell != null && spell.usesMaterial() && !spell.hasMaterialOverride() && material != null) {
            materialName = this.getMaterialName(material);
        }
        return this.getActiveWandName(spell, materialName);
    }

    private String getActiveWandName() {
        Spell spell = this.spells.getSpell(this.activeSpell);
        return this.getActiveWandName(spell);
    }

    public void updateName(boolean isActive) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(isActive ? this.getActiveWandName() : this.wandName);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    private void updateName() {
        this.updateName(true);
    }

    private String getLevelString(String prefix, float amount) {
        String suffix = "I";
        if (amount >= 1.0f) {
            suffix = "X";
        } else if ((double)amount > 0.8) {
            suffix = "V";
        } else if ((double)amount > 0.6) {
            suffix = "IV";
        } else if ((double)amount > 0.4) {
            suffix = "III";
        } else if ((double)amount > 0.2) {
            suffix = "II";
        }
        return prefix + " " + suffix;
    }

    private void updateLore() {
        this.updateLore(this.getSpells().length, this.getMaterials().length);
    }

    private void updateLore(int spellCount, int materialCount) {
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        Spell spell = this.spells.getSpell(this.activeSpell);
        if (spell != null && spellCount == 1 && materialCount <= 1) {
            this.addSpellLore(spell, lore);
        } else {
            lore.add("Knows " + spellCount + " Spells");
            if (materialCount > 0) {
                lore.add("Has " + materialCount + " Materials");
            }
        }
        int remaining = this.getRemainingUses();
        if (remaining > 0) {
            lore.add(ChatColor.RED + "" + remaining + " Uses Remaining");
        }
        if (this.xpRegeneration > 0) {
            lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + "Mana: " + this.xpMax);
            lore.add(ChatColor.RESET + "" + ChatColor.LIGHT_PURPLE + this.getLevelString("Mana Regeneration", this.xpRegeneration / 100));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("Protection", this.damageReduction));
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("Cost Reduction", this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("Cooldown Reduction", this.cooldownReduction));
        }
        if (this.speedIncrease > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("Haste", this.speedIncrease / WandLevel.maxSpeedIncrease));
        }
        if (this.power > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("Power", this.power));
        }
        if (this.damageReduction < 1.0f) {
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("Physical Protection", this.damageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("Projectile Protection", this.damageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("Fall Protection", this.damageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("Fire Protection", this.damageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString("Blast Protection", this.damageReductionExplosions));
            }
        }
        if (this.healthRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString("Health Regeneration", this.healthRegeneration / 20));
        }
        if (this.hungerRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString("Anti-Hunger", this.hungerRegeneration / 20));
        }
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        this.item.setType(enchantable ? EnchantableWandMaterial : WandMaterial);
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(Spells spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return !(item == null || item.getType() != WandMaterial && item.getType() != EnchantableWandMaterial || !InventoryUtils.hasMeta(item, "wand") && !InventoryUtils.hasMeta(item, "magic_wand"));
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && item.getType() != WandMaterial && InventoryUtils.hasMeta(item, "spell");
    }

    protected void updateInventory() {
        if (this.activePlayer == null) {
            return;
        }
        this.updateInventory(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    public void updateInventoryNames(boolean activeNames) {
        ItemStack[] contents;
        if (this.activePlayer == null || !this.isInventoryOpen()) {
            return;
        }
        for (ItemStack item : contents = this.activePlayer.getPlayer().getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || Wand.isWand(item)) continue;
            this.updateInventoryName(item, activeNames);
        }
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            Spell spell = this.activePlayer.getSpell(item.getType());
            if (spell != null) {
                this.updateSpellName(item, spell, activeName);
            }
        } else {
            this.updateMaterialName(item, activeName);
        }
    }

    protected void updateSpellName(ItemStack itemStack, Spell spell, boolean activeName) {
        ItemMeta meta = itemStack.getItemMeta();
        if (activeName) {
            meta.setDisplayName(this.getActiveWandName(spell));
        } else {
            meta.setDisplayName(ChatColor.GOLD + spell.getName());
        }
        ArrayList<String> lore = new ArrayList<String>();
        this.addSpellLore(spell, lore);
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        InventoryUtils.addGlow(itemStack);
        Object spellNode = InventoryUtils.createNode(itemStack, "spell");
        InventoryUtils.setMeta(spellNode, "key", spell.getKey());
    }

    protected void updateMaterialName(ItemStack itemStack, boolean activeName) {
        ItemMeta meta = itemStack.getItemMeta();
        if (activeName) {
            meta.setDisplayName(this.getActiveWandName(itemStack.getType()));
        } else {
            meta.setDisplayName(this.getMaterialName(itemStack.getType()));
        }
        itemStack.setItemMeta(meta);
    }

    /*
     * WARNING - void declaration
     */
    private void updateInventory(int itemSlot) {
        if (this.activePlayer == null) {
            return;
        }
        Player player = this.activePlayer.getPlayer();
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        inventory.setItem(itemSlot, this.item);
        String[] spells = StringUtils.split((String)this.wandSpells, (String)"|");
        LinkedList<ItemStack> unpositionedSpells = new LinkedList<ItemStack>();
        for (int i = 0; i < spells.length; ++i) {
            int slot;
            String[] parts = StringUtils.split((String)spells[i], (String)"@");
            String spellName = parts[0];
            Spell spell = this.activePlayer.getSpell(spellName);
            if (spell == null) continue;
            ItemStack itemStack = new ItemStack(spell.getMaterial(), 1);
            itemStack = InventoryUtils.getCopy(itemStack);
            this.updateSpellName(itemStack, spell, true);
            int n = slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
            if (parts.length > 1 && slot != itemSlot) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            unpositionedSpells.add(itemStack);
        }
        String[] materials = StringUtils.split((String)this.wandMaterials, (String)"|");
        LinkedList<ItemStack> unpositionedMaterials = new LinkedList<ItemStack>();
        HashMap<Integer, ItemStack> positioned = new HashMap<Integer, ItemStack>();
        ItemStack eraseStack = null;
        ItemStack copyStack = null;
        for (int i = 0; i < materials.length; ++i) {
            ArrayList<String> lore;
            String[] stringArray = StringUtils.split((String)materials[i], (String)"@");
            String[] nameParts = StringUtils.split((String)stringArray[0], (String)":");
            int typeId = Integer.parseInt(nameParts[0]);
            if (typeId == 0) {
                typeId = EraseMaterial.getId();
            } else if (typeId == -1) {
                typeId = CopyMaterial.getId();
            }
            int dataId = nameParts.length > 1 ? Integer.parseInt(nameParts[1]) : 0;
            ItemStack itemStack = new ItemStack(typeId, 1, 0, Byte.valueOf((byte)dataId));
            itemStack = InventoryUtils.getCopy(itemStack);
            ItemMeta meta = itemStack.getItemMeta();
            if (typeId == EraseMaterial.getId()) {
                lore = new ArrayList<String>();
                lore.add("Fills with Air");
                meta.setLore(lore);
            } else if (typeId == CopyMaterial.getId()) {
                lore = new ArrayList();
                lore.add("Fills with the target material");
                meta.setLore(lore);
            } else {
                lore = new ArrayList();
                Material material = Material.getMaterial((int)typeId);
                if (material != null) {
                    lore.add(ChatColor.GRAY + this.getMaterialName(material, (byte)dataId));
                }
                lore.add(ChatColor.LIGHT_PURPLE + "Magic building material");
                meta.setLore(lore);
            }
            meta.setDisplayName(this.getActiveWandName(Material.getMaterial((int)typeId)));
            itemStack.setItemMeta(meta);
            int slot = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : itemSlot;
            ItemStack existing = inventory.getItem(slot);
            if (stringArray.length > 1 && slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                positioned.put(slot, itemStack);
                continue;
            }
            if (itemStack.getType() == EraseMaterial) {
                eraseStack = itemStack;
                continue;
            }
            if (itemStack.getType() == CopyMaterial) {
                copyStack = itemStack;
                continue;
            }
            unpositionedMaterials.add(itemStack);
        }
        if (unpositionedMaterials.size() > 0) {
            void var12_16;
            int materialSpaces = Math.min(unpositionedMaterials.size(), 3);
            int n = 8 - materialSpaces;
            while (unpositionedSpells.size() > 0 && var12_16 > 0) {
                inventory.addItem(new ItemStack[]{(ItemStack)unpositionedSpells.remove()});
                --var12_16;
            }
        }
        if (eraseStack != null) {
            Wand.addMaterialToInventory((Inventory)inventory, eraseStack);
        }
        if (copyStack != null) {
            Wand.addMaterialToInventory((Inventory)inventory, copyStack);
        }
        for (ItemStack itemStack : unpositionedSpells) {
            inventory.addItem(new ItemStack[]{itemStack});
        }
        for (Map.Entry entry : positioned.entrySet()) {
            int slot = (Integer)entry.getKey();
            ItemStack itemStack = (ItemStack)entry.getValue();
            ItemStack existing = inventory.getItem(slot);
            if (slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        for (ItemStack itemStack : unpositionedMaterials) {
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        this.updateName();
        player.updateInventory();
    }

    protected void addSpellLore(Spell spell, List<String> lore) {
        lore.add(spell.getDescription());
        List<CastingCost> costs = spell.getCosts();
        if (costs != null) {
            for (CastingCost cost : costs) {
                if (!cost.hasCosts(this)) continue;
                lore.add(ChatColor.YELLOW + "Costs " + cost.getFullDescription(this));
            }
        }
    }

    private static void addMaterialToInventory(Inventory inventory, ItemStack stack) {
        for (int i = 8; i >= 0; --i) {
            ItemStack existing = inventory.getItem(i);
            if (existing != null && existing.getType() != Material.AIR) continue;
            inventory.setItem(i, stack);
            return;
        }
        inventory.addItem(new ItemStack[]{stack});
    }

    public void saveInventory() {
        Integer position;
        String[] pieces;
        if (this.activePlayer == null) {
            return;
        }
        PlayerInventory inventory = this.activePlayer.getPlayer().getInventory();
        String[] currentSpells = this.getSpells();
        String[] currentMaterials = this.getMaterials();
        HashMap<String, Integer> spellMap = new HashMap<String, Integer>();
        HashMap<String, Integer> materialMap = new HashMap<String, Integer>();
        for (String string : currentSpells) {
            pieces = StringUtils.split((String)string, (String)"@");
            position = pieces.length > 1 ? Integer.valueOf(Integer.parseInt(pieces[1])) : null;
            spellMap.put(pieces[0], position);
        }
        for (String string : currentMaterials) {
            pieces = StringUtils.split((String)string, (String)"@");
            position = pieces.length > 1 ? Integer.valueOf(Integer.parseInt(pieces[1])) : null;
            materialMap.put(pieces[0], position);
        }
        ItemStack[] items = inventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || Wand.isWand(items[i])) continue;
            Material material = items[i].getType();
            if (Wand.isSpell(items[i])) {
                Spell spell = this.activePlayer.getSpell(material);
                if (spell == null || !spellMap.containsKey(spell.getKey())) continue;
                spellMap.put(spell.getKey(), i);
                continue;
            }
            Set<Material> set = this.activePlayer.getMaster().getBuildingMaterials();
            if (material == Material.AIR || !set.contains(material) && material != EraseMaterial) continue;
            String materialKey = material.getId() + ":" + items[i].getData().getData();
            if (material == EraseMaterial) {
                materialKey = "0:0";
            } else if (material == CopyMaterial) {
                materialKey = "-1:0";
            }
            if (!materialMap.containsKey(materialKey)) continue;
            materialMap.put(materialKey, i);
        }
        ArrayList<String> spellNames = new ArrayList<String>();
        ArrayList<String> materialNames = new ArrayList<String>();
        for (Map.Entry spellEntry : spellMap.entrySet()) {
            position = (Integer)spellEntry.getValue();
            String spellName = (String)spellEntry.getKey();
            if (position != null) {
                spellName = spellName + "@" + position;
            }
            spellNames.add(spellName);
        }
        for (Map.Entry materialEntry : materialMap.entrySet()) {
            position = (Integer)materialEntry.getValue();
            String materialName = (String)materialEntry.getKey();
            if (position != null) {
                materialName = materialName + "@" + position;
            }
            materialNames.add(materialName);
        }
        this.setSpells(spellNames);
        this.setMaterials(materialNames);
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    protected void randomize(int level, boolean additive) {
        if (!wandTemplates.containsKey("random")) {
            return;
        }
        ConfigurationNode randomTemplate = wandTemplates.get("random");
        if (!additive && randomTemplate.containsKey("name")) {
            this.wandName = randomTemplate.getString("name");
        }
        WandLevel.randomizeWand(this, additive, level);
    }

    public static Wand createWand(Spells spells, String templateName) {
        Wand wand = new Wand(spells);
        ArrayList<String> defaultSpells = new ArrayList<String>();
        String wandName = defaultWandName;
        if (templateName != null && templateName.length() > 0) {
            List<Object> materialList;
            if ((templateName.equals("random") || templateName.startsWith("random(")) && wandTemplates.containsKey("random")) {
                int level = 1;
                if (!templateName.equals("random")) {
                    String randomLevel = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
                    level = Integer.parseInt(randomLevel);
                }
                wand.randomize(level, false);
                return wand;
            }
            if (!wandTemplates.containsKey(templateName)) {
                return null;
            }
            ConfigurationNode wandConfig = wandTemplates.get(templateName);
            wandName = wandConfig.getString("name", wandName);
            List<Object> spellList = wandConfig.getList("spells");
            if (spellList != null) {
                for (Object spellName : spellList) {
                    defaultSpells.add((String)spellName);
                }
            }
            if ((materialList = wandConfig.getList("materials")) != null) {
                for (Object materialNameAndData : materialList) {
                    String[] materialParts = StringUtils.split((String)((String)materialNameAndData), (char)':');
                    String materialName = materialParts[0];
                    byte data = 0;
                    if (materialParts.length > 1) {
                        data = Byte.parseByte(materialParts[1]);
                    }
                    if (materialName.equals("erase")) {
                        wand.addMaterial(EraseMaterial, (byte)0, false);
                        continue;
                    }
                    if (materialName.equals("copy") || materialName.equals("clone")) {
                        wand.addMaterial(CopyMaterial, (byte)0, false);
                        continue;
                    }
                    wand.addMaterial(ConfigurationNode.toMaterial(materialName), data, false);
                }
            }
            wand.configureProperties(wandConfig);
        }
        wand.addSpells(defaultSpells);
        wand.setName(wandName);
        return wand;
    }

    public void add(Wand other) {
        String[] materials;
        String[] spells;
        this.costReduction = Math.max(this.costReduction, other.costReduction);
        this.power = Math.max(this.power, other.power);
        this.damageReduction = Math.max(this.damageReduction, other.damageReduction);
        this.damageReductionPhysical = Math.max(this.damageReductionPhysical, other.damageReductionPhysical);
        this.damageReductionProjectiles = Math.max(this.damageReductionProjectiles, other.damageReductionProjectiles);
        this.damageReductionFalling = Math.max(this.damageReductionFalling, other.damageReductionFalling);
        this.damageReductionFire = Math.max(this.damageReductionFire, other.damageReductionFire);
        this.damageReductionExplosions = Math.max(this.damageReductionExplosions, other.damageReductionExplosions);
        this.xpRegeneration = Math.max(this.xpRegeneration, other.xpRegeneration);
        this.xpMax = Math.max(this.xpMax, other.xpMax);
        this.xp = Math.max(this.xp, other.xp);
        this.healthRegeneration = Math.max(this.healthRegeneration, other.healthRegeneration);
        this.hungerRegeneration = Math.max(this.hungerRegeneration, other.hungerRegeneration);
        this.speedIncrease = Math.max(this.speedIncrease, other.speedIncrease);
        this.effectColor = Math.max(this.effectColor, other.effectColor);
        this.uses = this.uses == 0 || other.uses == 0 ? 0 : (this.uses += other.uses);
        for (String spell : spells = other.getSpells()) {
            this.addSpell(spell.split("@")[0], false);
        }
        for (String material : materials = other.getMaterials()) {
            this.addMaterial(material.split("@")[0], false);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public void configureProperties(ConfigurationNode wandConfig) {
        this.costReduction = (float)wandConfig.getDouble("cost_reduction", this.costReduction);
        this.power = (float)wandConfig.getDouble("power", this.power);
        this.damageReduction = (float)wandConfig.getDouble("protection", this.damageReduction);
        this.damageReductionPhysical = (float)wandConfig.getDouble("protection_physical", this.damageReductionPhysical);
        this.damageReductionProjectiles = (float)wandConfig.getDouble("protection_projectiles", this.damageReductionPhysical);
        this.damageReductionFalling = (float)wandConfig.getDouble("protection_falling", this.damageReductionFalling);
        this.damageReductionFire = (float)wandConfig.getDouble("protection_fire", this.damageReductionFire);
        this.damageReductionExplosions = (float)wandConfig.getDouble("protection_explosions", this.damageReductionExplosions);
        this.xpRegeneration = wandConfig.getInt("xp_regeneration", this.xpRegeneration);
        this.xpMax = wandConfig.getInt("xp_max", this.xpMax);
        this.xp = wandConfig.getInt("xp", this.xp);
        this.healthRegeneration = wandConfig.getInt("health_regeneration", this.healthRegeneration);
        this.hungerRegeneration = wandConfig.getInt("hunger_regeneration", this.hungerRegeneration);
        this.uses = wandConfig.getInt("uses", this.uses);
        this.effectColor = Integer.parseInt(wandConfig.getString("effect_color", "0"), 16);
        float oldWalkSpeedIncrease = this.speedIncrease;
        this.speedIncrease = (float)wandConfig.getDouble("haste", this.speedIncrease);
        if (this.activePlayer != null && this.speedIncrease != oldWalkSpeedIncrease) {
            Player player = this.activePlayer.getPlayer();
            player.setWalkSpeed(this.defaultWalkSpeed + this.speedIncrease);
            player.setFlySpeed(this.defaultFlySpeed + this.speedIncrease);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public static void reset(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        propertiesFile.delete();
    }

    public static void load(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        if (!propertiesFile.exists()) {
            File oldDefaults = new File(dataFolder, propertiesFileNameDefaults);
            oldDefaults.delete();
            plugin.saveResource(propertiesFileNameDefaults, false);
            Wand.loadProperties(plugin.getResource(propertiesFileNameDefaults));
        } else {
            Wand.loadProperties(propertiesFile);
        }
    }

    private static void loadProperties(File propertiesFile) {
        Wand.loadProperties(new Configuration(propertiesFile));
    }

    private static void loadProperties(InputStream properties) {
        Wand.loadProperties(new Configuration(properties));
    }

    private static void loadProperties(Configuration properties) {
        properties.load();
        wandTemplates.clear();
        ConfigurationNode wandList = properties.getNode("wands");
        if (wandList == null) {
            return;
        }
        List<String> wandKeys = wandList.getKeys();
        for (String key : wandKeys) {
            ConfigurationNode wandNode = wandList.getNode(key);
            wandNode.setProperty("key", key);
            wandTemplates.put(key, wandNode);
            if (!key.equals("random")) continue;
            WandLevel.mapLevels(wandNode);
        }
    }

    public static Collection<ConfigurationNode> getWandTemplates() {
        return wandTemplates.values();
    }

    private void updateActiveMaterial() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activePlayer.clearBuildingMaterial();
        } else {
            String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
            if (pieces.length > 0) {
                byte data = 0;
                if (pieces.length > 1) {
                    data = Byte.parseByte(pieces[1]);
                }
                int materialId = Integer.parseInt(pieces[0]);
                Material material = null;
                material = materialId == 0 ? EraseMaterial : (materialId == -1 ? CopyMaterial : Material.getMaterial((int)materialId));
                this.activePlayer.setBuildingMaterial(material, data);
            }
        }
    }

    private void openInventory(int itemSlot) {
        if (this.activePlayer == null) {
            return;
        }
        if (this.activePlayer.storeInventory(itemSlot, this.item)) {
            this.updateInventory(itemSlot);
            this.activePlayer.getPlayer().updateInventory();
        }
    }

    public void openInventory() {
        if (this.activePlayer == null) {
            return;
        }
        this.openInventory(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    private void closeInventory(int itemSlot) {
        this.saveInventory();
        if (this.activePlayer != null) {
            this.activePlayer.restoreInventory(itemSlot, this.item);
            this.activePlayer.getPlayer().updateInventory();
        }
    }

    public void closeInventory() {
        if (this.activePlayer == null) {
            return;
        }
        this.closeInventory(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    public void activate(PlayerSpells playerSpells) {
        this.activePlayer = playerSpells;
        Player player = this.activePlayer.getPlayer();
        if (this.speedIncrease > 0.0f) {
            try {
                player.setWalkSpeed(this.defaultWalkSpeed + this.speedIncrease);
                player.setFlySpeed(this.defaultFlySpeed + this.speedIncrease);
            }
            catch (Exception ex2) {
                try {
                    player.setWalkSpeed(this.defaultWalkSpeed);
                    player.setFlySpeed(this.defaultFlySpeed);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        this.activePlayer.setActiveWand(this);
        if (this.xpRegeneration > 0) {
            this.storedXpLevel = player.getLevel();
            this.storedXpProgress = player.getExp();
            this.storedXp = 0;
            this.updateMana();
        }
        this.updateActiveMaterial();
        this.updateName();
        if (this.effectColor != 0) {
            InventoryUtils.addPotionEffect((LivingEntity)player, this.effectColor);
        }
    }

    protected void updateMana() {
        if (this.activePlayer != null && this.xpMax > 0 && this.xpRegeneration > 0) {
            Player player = this.activePlayer.getPlayer();
            player.setLevel(0);
            player.setExp((float)this.xp / (float)this.xpMax);
        }
    }

    public boolean isInventoryOpen() {
        return this.activePlayer != null && this.activePlayer.hasStoredInventory();
    }

    public void deactivate() {
        if (this.activePlayer == null) {
            return;
        }
        this.deactivate(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    public void deactivate(int itemSlot) {
        if (this.activePlayer == null) {
            return;
        }
        if (this.effectColor > 0) {
            InventoryUtils.removePotionEffect((LivingEntity)this.activePlayer.getPlayer());
        }
        this.activePlayer.deactivateAllSpells();
        if (this.isInventoryOpen()) {
            this.closeInventory(itemSlot);
        }
        if (this.xpRegeneration > 0) {
            this.xp = this.activePlayer.getExperience();
            this.activePlayer.player.setExp(this.storedXpProgress);
            this.activePlayer.player.setLevel(this.storedXpLevel);
            this.activePlayer.player.giveExp(this.storedXp);
            this.storedXp = 0;
            this.storedXpProgress = 0.0f;
            this.storedXpLevel = 0;
        }
        if (this.speedIncrease > 0.0f) {
            try {
                this.activePlayer.getPlayer().setWalkSpeed(this.defaultWalkSpeed);
                this.activePlayer.getPlayer().setFlySpeed(this.defaultFlySpeed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activePlayer.setActiveWand(null);
        this.activePlayer = null;
        this.saveState();
    }

    public Spell getActiveSpell() {
        if (this.activePlayer == null) {
            return null;
        }
        return this.activePlayer.getSpell(this.activeSpell);
    }

    public boolean cast() {
        Spell spell = this.getActiveSpell();
        if (spell != null && spell.cast()) {
            this.use();
            return true;
        }
        return false;
    }

    protected void use() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.uses > 0) {
            --this.uses;
            if (this.uses <= 0) {
                Player player = this.activePlayer.getPlayer();
                this.deactivate();
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                player.updateInventory();
            } else {
                this.updateName();
                this.updateLore(this.getSpells().length, this.getMaterials().length);
                this.saveState();
            }
        }
    }

    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (this.activePlayer == null) {
            return;
        }
        if (this.xpRegeneration > 0) {
            this.storedXp += event.getAmount();
            event.setAmount(0);
        }
    }

    public void processRegeneration() {
        if (this.activePlayer == null) {
            return;
        }
        Player player = this.activePlayer.getPlayer();
        if (this.xpRegeneration > 0) {
            this.xp = Math.min(this.xpMax, this.xp + this.xpRegeneration);
            this.updateMana();
        }
        double maxHealth = player.getMaxHealth();
        if (this.healthRegeneration > 0 && player.getHealth() < maxHealth) {
            player.setHealth(Math.min(maxHealth, player.getHealth() + (double)this.healthRegeneration));
        }
        double maxFoodLevel = 20.0;
        if (this.hungerRegeneration > 0 && (double)player.getFoodLevel() < maxFoodLevel) {
            player.setExhaustion(0.0f);
            player.setFoodLevel(Math.min(20, player.getFoodLevel() + this.hungerRegeneration));
        }
        if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
            player.setFireTicks(0);
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Wand)) {
            return false;
        }
        Wand otherWand = (Wand)other;
        if (this.id == null || otherWand.id == null) {
            return false;
        }
        return otherWand.id.equals(this.id);
    }

    public Spells getMaster() {
        return this.spells;
    }

    public void cycleSpells() {
        String[] spells = this.getSpells();
        if (spells.length == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.activeSpell = spells[0].split("@")[0];
            return;
        }
        int spellIndex = 0;
        for (int i = 0; i < spells.length; ++i) {
            if (!spells[i].split("@")[0].equals(this.activeSpell)) continue;
            spellIndex = i;
            break;
        }
        spellIndex = (spellIndex + 1) % spells.length;
        this.setActiveSpell(spells[spellIndex].split("@")[0]);
    }

    public void cycleMaterials() {
        String[] materials = this.getMaterials();
        if (materials.length == 0) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activeMaterial = materials[0].split("@")[0];
            return;
        }
        int materialIndex = 0;
        for (int i = 0; i < materials.length; ++i) {
            if (!materials[i].split("@")[0].equals(this.activeMaterial)) continue;
            materialIndex = i;
            break;
        }
        materialIndex = (materialIndex + 1) % materials.length;
        this.setActiveMaterial(materials[materialIndex].split("@")[0]);
    }

    public boolean hasExperience() {
        return this.xpRegeneration > 0;
    }
}

