/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.blocks.ConstructBatch;
import com.elmakers.mine.bukkit.plugins.magic.blocks.ConstructionType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class ConstructSpell
extends Spell {
    private ConstructionType defaultConstructionType = ConstructionType.SPHERE;
    private int defaultRadius = 2;
    private int timeToLive = 0;
    private Set<Material> indestructible = null;

    public SpellResult onCast(ConfigurationNode parameters) {
        this.targetThrough(Material.GLASS);
        Block target = this.getTarget().getBlock();
        if (target == null) {
            this.initializeTargeting(this.player);
            this.noTargetThrough(Material.GLASS);
            target = this.getTarget().getBlock();
        }
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (parameters.containsKey("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        if (!this.hasBuildPermission(target)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Material material = target.getType();
        byte data = target.getData();
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = ConstructSpell.getItemData(buildWith);
        }
        ConstructionType conType = this.defaultConstructionType;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Material materialOverride = parameters.getMaterial("material");
        if (materialOverride != null) {
            material = materialOverride;
            data = 0;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        radius = parameters.getInt("size", radius);
        String typeString = parameters.getString("type", "");
        ConstructionType testType = ConstructionType.parseString(typeString, ConstructionType.UNKNOWN);
        if (testType != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        this.fillArea(target, radius, material, data, !hollow, conType);
        return SpellResult.SUCCESS;
    }

    public void fillArea(Block target, int radius, Material material, byte data, boolean fill, ConstructionType type) {
        ConstructBatch batch = new ConstructBatch(this, target.getLocation(), type, radius, fill, material, data, this.indestructible);
        this.spells.addPendingBlockBatch(batch);
    }

    public void onLoad(ConfigurationNode properties) {
        this.timeToLive = properties.getInt("undo", this.timeToLive);
        this.indestructible = properties.getMaterials("indestructible", "");
    }

    public boolean usesMaterial() {
        return true;
    }
}

