/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class BlinkSpell
extends Spell {
    private boolean autoAscend = true;
    private boolean autoDescend = true;
    private boolean autoPassthrough = true;
    private int verticalSearchDistance = 255;

    protected boolean ascend() {
        Location location = this.findPlaceToStand(this.player.getLocation(), true);
        if (location != null) {
            this.castMessage("You ascend");
            this.player.teleport(location);
            return true;
        }
        return false;
    }

    protected boolean descend() {
        Location location = this.findPlaceToStand(this.player.getLocation(), false);
        if (location != null) {
            this.castMessage("You descend");
            this.player.teleport(location);
            return true;
        }
        return false;
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        String elevateType = parameters.getString("type", "");
        if (elevateType.equals("descend")) {
            if (!this.descend()) {
                this.castMessage("Nowhere to go down");
                return SpellResult.NO_TARGET;
            }
            return SpellResult.SUCCESS;
        }
        if (elevateType.equals("ascend")) {
            if (!this.ascend()) {
                this.castMessage("Nowhere to go up");
                return SpellResult.NO_TARGET;
            }
            return SpellResult.SUCCESS;
        }
        if (this.getYRotation() < -80.0 && this.autoDescend && this.descend()) {
            return SpellResult.SUCCESS;
        }
        if (this.getYRotation() > 80.0 && this.autoAscend && this.ascend()) {
            return SpellResult.SUCCESS;
        }
        if (this.autoPassthrough) {
            Block firstBlock = this.getNextBlock();
            if (firstBlock != null && firstBlock.getType() != Material.AIR && !this.isWater(firstBlock.getType())) {
                this.setReverseTargeting(true);
                this.setTargetHeightRequired(2);
                this.targetThrough(Material.AIR);
            } else {
                this.targetThrough(Material.GLASS);
                this.targetThrough(Material.THIN_GLASS);
                this.targetThrough(Material.STAINED_GLASS);
                this.targetThrough(Material.STAINED_GLASS_PANE);
                this.targetThrough(Material.WATER);
                this.targetThrough(Material.STATIONARY_WATER);
            }
        }
        Block target = this.getTargetBlock();
        Block face = this.getLastBlock();
        if (target == null) {
            this.castMessage("Nowhere to blink to");
            return SpellResult.NO_TARGET;
        }
        World world = this.player.getWorld();
        Block destination = face;
        int distanceUp = 0;
        int distanceDown = 0;
        if (this.isReverseTargeting()) {
            destination = target;
        }
        Block groundBlock = destination.getRelative(BlockFace.DOWN);
        while (distanceDown < this.verticalSearchDistance && !this.isOkToStandOn(groundBlock.getType())) {
            destination = groundBlock;
            groundBlock = destination.getRelative(BlockFace.DOWN);
            ++distanceDown;
        }
        Block ledge = null;
        if (!this.isReverseTargeting()) {
            ledge = target;
            Block inFront = face;
            Block oneUp = null;
            Block twoUp = null;
            do {
                oneUp = ledge.getRelative(BlockFace.UP);
                twoUp = oneUp.getRelative(BlockFace.UP);
                inFront = inFront.getRelative(BlockFace.UP);
                ledge = ledge.getRelative(BlockFace.UP);
            } while (++distanceUp < this.verticalSearchDistance && this.isOkToStandIn(inFront.getType()) && (!this.isOkToStandOn(groundBlock.getType()) || !this.isOkToStandIn(oneUp.getType()) || !this.isOkToStandIn(twoUp.getType())));
        }
        if (ledge != null && distanceUp < distanceDown) {
            destination = ledge;
        }
        Block oneUp = destination.getRelative(BlockFace.UP);
        Block twoUp = oneUp.getRelative(BlockFace.UP);
        if (!this.isOkToStandIn(oneUp.getType()) || !this.isOkToStandIn(twoUp.getType())) {
            this.castMessage("You can't fit in there!");
            return SpellResult.NO_TARGET;
        }
        this.castMessage("Blink!");
        Location targetLocation = new Location(world, (double)destination.getX() + 0.5, (double)destination.getY(), (double)destination.getZ() + 0.5, this.player.getLocation().getYaw(), this.player.getLocation().getPitch());
        this.player.teleport(targetLocation);
        return SpellResult.SUCCESS;
    }

    public void onLoad(ConfigurationNode properties) {
        this.autoAscend = properties.getBoolean("allow_ascend", this.autoAscend);
        this.autoDescend = properties.getBoolean("allow_descend", this.autoDescend);
        this.autoPassthrough = properties.getBoolean("allow_passthrough", this.autoPassthrough);
    }
}

