/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.event.entity.EntityDamageEvent;

public class InvincibleSpell
extends Spell {
    protected float protectAmount = 0.0f;
    protected int amount = 100;

    public SpellResult onCast(ConfigurationNode parameters) {
        this.amount = parameters.getInt("amount", this.amount);
        if (this.protectAmount != 0.0f) {
            this.deactivate();
        } else {
            this.activate();
        }
        return SpellResult.SUCCESS;
    }

    public void onDeactivate() {
        this.sendMessage("You feel normal.");
        this.spells.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.protectAmount = 0.0f;
    }

    public void onActivate() {
        this.spells.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.amount >= 100) {
            this.castMessage("You feel invincible!");
        } else {
            this.castMessage("You feel strong!");
        }
        this.protectAmount = (float)this.amount / 100.0f;
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (this.protectAmount > 0.0f) {
            if (this.protectAmount >= 1.0f) {
                event.setCancelled(true);
            } else {
                int newDamage = (int)Math.floor((double)(1.0f - this.protectAmount) * event.getDamage());
                if (newDamage == 0) {
                    newDamage = 1;
                }
                event.setDamage((double)newDamage);
            }
        }
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

