/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class ConstructSpell
extends Spell {
    private ConstructionType defaultConstructionType = ConstructionType.SPHERE;
    private int defaultRadius = 2;
    private int timeToLive = 0;
    private Set<Material> indestructible = null;

    public SpellResult onCast(ConfigurationNode parameters) {
        this.targetThrough(Material.GLASS);
        Block target = this.getTarget().getBlock();
        if (target == null) {
            this.initializeTargeting(this.player);
            this.noTargetThrough(Material.GLASS);
            target = this.getTarget().getBlock();
        }
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (parameters.containsKey("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        if (!this.hasBuildPermission(target)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Material material = target.getType();
        byte data = target.getData();
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = ConstructSpell.getItemData(buildWith);
        }
        ConstructionType conType = this.defaultConstructionType;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Material materialOverride = parameters.getMaterial("material");
        if (materialOverride != null) {
            material = materialOverride;
            data = 0;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        radius = parameters.getInt("size", radius);
        String typeString = parameters.getString("type", "");
        ConstructionType testType = ConstructionType.parseString(typeString, ConstructionType.UNKNOWN);
        if (testType != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        this.fillArea(target, radius, material, data, !hollow, conType);
        return SpellResult.SUCCESS;
    }

    public void fillArea(Block target, int radius, Material material, byte data, boolean fill, ConstructionType type) {
        BlockList constructedBlocks = new BlockList();
        int x = 0;
        while (x <= radius) {
            int y = 0;
            while (y <= radius) {
                int z = 0;
                while (z <= radius) {
                    boolean fillBlock = false;
                    switch (type) {
                        case SPHERE: {
                            int maxDistanceSquared = radius * radius;
                            float mx = (float)x - 0.5f;
                            float my = (float)y - 0.5f;
                            float mz = (float)z - 0.5f;
                            int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                            if (fill) {
                                fillBlock = distanceSquared <= maxDistanceSquared;
                                break;
                            }
                            int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                            fillBlock = maxDistanceSquared >= distanceSquared && maxDistanceSquared <= outerDistanceSquared;
                            break;
                        }
                        case PYRAMID: {
                            int elevation = radius - y;
                            if (fill) {
                                fillBlock = x <= elevation && z <= elevation;
                                break;
                            }
                            fillBlock = x == elevation && z <= elevation || z == elevation && x <= elevation;
                            break;
                        }
                        default: {
                            boolean bl = fill ? true : (fillBlock = x == radius || y == radius || z == radius);
                        }
                    }
                    if (fillBlock) {
                        this.constructBlock(x, y, z, target, material, data, constructedBlocks);
                        this.constructBlock(-x, y, z, target, material, data, constructedBlocks);
                        this.constructBlock(x, -y, z, target, material, data, constructedBlocks);
                        this.constructBlock(x, y, -z, target, material, data, constructedBlocks);
                        this.constructBlock(-x, -y, z, target, material, data, constructedBlocks);
                        this.constructBlock(x, -y, -z, target, material, data, constructedBlocks);
                        this.constructBlock(-x, y, -z, target, material, data, constructedBlocks);
                        this.constructBlock(-x, -y, -z, target, material, data, constructedBlocks);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.timeToLive == 0) {
            this.spells.addToUndoQueue(this.player, constructedBlocks);
        } else {
            constructedBlocks.setTimeToLive(this.timeToLive);
            this.spells.scheduleCleanup(constructedBlocks);
        }
        this.castMessage("Constructed " + constructedBlocks.size() + "blocks");
    }

    public int getDistanceSquared(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    public void constructBlock(int dx, int dy, int dz, Block centerPoint, Material material, byte data, BlockList constructedBlocks) {
        int x = centerPoint.getX() + dx;
        int y = centerPoint.getY() + dy;
        int z = centerPoint.getZ() + dz;
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        if (!this.isDestructible(block)) {
            return;
        }
        if (!this.hasBuildPermission(block)) {
            return;
        }
        constructedBlocks.add(block);
        block.setType(material);
        block.setData(data);
    }

    public boolean isDestructible(Block block) {
        return this.spells.getDestructibleMaterials().contains(block.getType()) && !this.indestructible.contains(block.getType());
    }

    public void onLoad(ConfigurationNode properties) {
        this.timeToLive = properties.getInt("undo", this.timeToLive);
        this.indestructible = properties.getMaterials("indestructible", "");
    }

    public boolean usesMaterial() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstructionType {
        SPHERE,
        CUBOID,
        PYRAMID,
        UNKNOWN;


        public static ConstructionType parseString(String s, ConstructionType defaultType) {
            ConstructionType construct = defaultType;
            ConstructionType[] constructionTypeArray = ConstructionType.values();
            int n = constructionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConstructionType t = constructionTypeArray[n2];
                if (t.name().equalsIgnoreCase(s)) {
                    construct = t;
                }
                ++n2;
            }
            return construct;
        }
    }
}

