/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastingCost {
    protected Material item;
    protected byte data;
    protected double amount;
    protected int xp;

    public CastingCost(ConfigurationNode config) {
        this.item = config.getMaterial("material");
        this.amount = config.getDouble("amount", 1.0);
        this.xp = config.getInt("xp", 0);
        this.data = 0;
    }

    public CastingCost(Material item, double amount) {
        this.item = item;
        this.data = 0;
        this.amount = amount;
    }

    public CastingCost(Material item, byte data, double amount) {
        this.item = item;
        this.data = data;
        this.amount = amount;
    }

    public Material getMaterial() {
        return this.item;
    }

    public Map<String, Object> export() {
        HashMap<String, Object> cost = new HashMap<String, Object>();
        cost.put("material", this.item.name().toLowerCase());
        cost.put("amount", this.amount);
        cost.put("xp", this.xp);
        return cost;
    }

    public boolean has(PlayerSpells playerSpells) {
        boolean hasXp;
        Inventory inventory = playerSpells.getInventory();
        boolean hasItem = this.item == null || inventory.contains(this.item, this.getAmount(playerSpells));
        boolean bl = hasXp = this.xp <= 0 || playerSpells.getExperience() >= this.getXP(playerSpells);
        return hasItem && hasXp;
    }

    public void use(PlayerSpells playerSpells) {
        int xp;
        Inventory inventory = playerSpells.getInventory();
        if (this.item != null) {
            ItemStack itemStack = this.getItemStack();
            inventory.removeItem(new ItemStack[]{itemStack});
        }
        if ((xp = this.getXP(playerSpells)) > 0) {
            playerSpells.removeExperience(xp);
        }
    }

    protected ItemStack getItemStack() {
        return new ItemStack(this.item, this.getAmount(), 0, Byte.valueOf(this.data));
    }

    protected int getAmount() {
        return (int)Math.ceil(this.amount);
    }

    protected int getXP() {
        return this.xp;
    }

    protected int getAmount(CostReducer reducer) {
        double reducedAmount = this.amount;
        float reduction = reducer.getCostReduction();
        if (reduction > 0.0f) {
            reducedAmount = (double)(1.0f - reduction) * reducedAmount;
        }
        return (int)Math.ceil(reducedAmount);
    }

    protected int getXP(CostReducer reducer) {
        float reducedAmount = this.xp;
        float reduction = reducer.getCostReduction();
        if (reduction > 0.0f) {
            reducedAmount = (1.0f - reduction) * reducedAmount;
        }
        return (int)Math.ceil(reducedAmount);
    }

    public boolean hasCosts(CostReducer reducer) {
        return this.item != null && this.getAmount(reducer) > 0 || this.getXP(reducer) > 0;
    }

    public String getDescription() {
        if (this.item != null && this.getAmount() != 0) {
            return this.item.name().toLowerCase().replace("_", " ").replace(" block", "");
        }
        return "XP";
    }

    public String getFullDescription(CostReducer reducer) {
        if (this.item != null) {
            return String.valueOf(this.getAmount(reducer)) + " " + this.item.name().toLowerCase().replace("_", " ").replace(" block", "");
        }
        return String.valueOf(this.getXP(reducer)) + " XP";
    }
}

