/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class LevitateSpell
extends Spell {
    private long levitateEnded;
    private final long safetyLength = 10000L;
    private float flightSpeed = 0.6f;

    public SpellResult onCast(ConfigurationNode parameters) {
        this.flightSpeed = (float)parameters.getDouble("speed", this.flightSpeed);
        if (this.player.getAllowFlight()) {
            this.deactivate();
            return SpellResult.COST_FREE;
        }
        this.activate();
        return SpellResult.SUCCESS;
    }

    public void onDeactivate() {
        this.player.setFlying(false);
        this.player.setAllowFlight(false);
        this.spells.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.levitateEnded = System.currentTimeMillis();
        this.sendMessage("You feel heavier");
    }

    public void onActivate() {
        Vector velocity = this.player.getVelocity();
        velocity.setY(velocity.getY() + 2.0);
        this.player.setVelocity(velocity);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.spells.getPlugin(), new Runnable(){

            public void run() {
                LevitateSpell.this.player.setFlySpeed(LevitateSpell.this.flightSpeed);
                LevitateSpell.this.player.setAllowFlight(true);
                LevitateSpell.this.player.setFlying(true);
            }
        }, 2L);
        this.castMessage("You feel lighter");
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.spells.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.levitateEnded == 0L) {
            return;
        }
        if (this.levitateEnded + 10000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.levitateEnded = 0L;
        }
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

