/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class ArrowSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        int arrowCount = 1;
        arrowCount = parameters.getInt("count", arrowCount);
        boolean useFire = parameters.getBoolean("fire", false);
        float speed = 0.6f;
        float spread = 12.0f;
        double damage = 2.0;
        speed = (float)parameters.getDouble("speed", speed);
        spread = (float)parameters.getDouble("spread", spread);
        damage = parameters.getDouble("damage", damage);
        Vector direction = this.player.getLocation().getDirection();
        int ai = 0;
        while (ai < arrowCount) {
            Arrow arrow = null;
            Location location = this.player.getLocation();
            location.setX(location.getX() + direction.getX() * (1.0 + Math.random() * (double)arrowCount));
            location.setY(location.getY() + 1.5);
            location.setZ(location.getZ() + direction.getZ() * (1.0 + Math.random() * (double)arrowCount));
            arrow = this.player.getWorld().spawnArrow(location, direction, speed, spread);
            if (arrow == null) {
                this.sendMessage("One of your arrows fizzled");
                return SpellResult.FAILURE;
            }
            arrow.setShooter((LivingEntity)this.player);
            if (useFire) {
                arrow.setFireTicks(300);
            }
            try {
                Method getHandleMethod = arrow.getClass().getMethod("getHandle", new Class[0]);
                Object handle = getHandleMethod.invoke((Object)arrow, new Object[0]);
                Field fromPlayerField = handle.getClass().getField("fromPlayer");
                fromPlayerField.setInt(handle, 2);
                Method setDamageMethod = handle.getClass().getMethod("b", Double.TYPE);
                setDamageMethod.invoke(handle, damage);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            arrow.setTicksLived(300);
            ++ai;
        }
        this.castMessage("You fire some magical arrows");
        return SpellResult.SUCCESS;
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

